/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.Log;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.diagnostics.ConduitNeighborUpdateTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractConduitNetwork<T extends IConduit, I extends T> {
    private final List<I> conduits = new ArrayList<I>();
    protected final Class<I> implClass;
    protected final Class<T> baseConduitClass;
    private static final EnumFacing[] WEDUNS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};

    protected AbstractConduitNetwork(Class<I> implClass, Class<T> baseConduitClass) {
        this.implClass = implClass;
        this.baseConduitClass = baseConduitClass;
    }

    public void init(IConduitBundle tile, Collection<I> connections, World world) {
        if (world.field_72995_K) {
            throw new UnsupportedOperationException();
        }
        for (IConduit con : connections) {
            AbstractConduitNetwork<?, ?> network = con.getNetwork();
            if (network == null) continue;
            network.destroyNetwork();
        }
        this.setNetwork(world, tile);
    }

    public final Class<T> getBaseConduitType() {
        return this.baseConduitClass;
    }

    protected void setNetwork(World world, IConduitBundle tile) {
        T conduit = tile.getConduit(this.getBaseConduitType());
        if (conduit != null && this.implClass.isAssignableFrom(conduit.getClass()) && conduit.setNetwork(this)) {
            this.addConduit((IConduit)this.implClass.cast(conduit));
            TileEntity te = tile.getEntity();
            Collection<IConduit> connections = ConduitUtil.getConnectedConduits(world, te.func_174877_v(), this.getBaseConduitType());
            for (IConduit con : connections) {
                if (con.getNetwork() == null) {
                    this.setNetwork(world, con.getBundle());
                    continue;
                }
                if (con.getNetwork() == this) continue;
                con.getNetwork().destroyNetwork();
                this.setNetwork(world, con.getBundle());
            }
        }
    }

    public void addConduit(I newconduit) {
        if (this.conduits.isEmpty()) {
            ConduitNetworkTickHandler.instance.registerNetwork(this);
        }
        BlockPos newpos = null;
        boolean error = false;
        IConduitBundle newbundle = newconduit.getBundle();
        if (newbundle == null) {
            Log.info("Tried to add invalid conduit to network: ", newconduit);
            error = true;
        } else {
            TileEntity newte = newbundle.getEntity();
            if (!newte.func_145830_o()) {
                Log.info("Tried to add invalid (no world) conduit to network: ", newconduit);
                error = true;
            }
            if (newte.func_145837_r()) {
                Log.info("Tried to add invalid (invalidated) conduit to network: ", newconduit);
                error = true;
            }
            newpos = newte.func_174877_v();
            World newworld = newte.func_145831_w();
            if (!newworld.func_175667_e(newpos)) {
                Log.info("Tried to add invalid (unloaded) conduit to network: ", newconduit);
                error = true;
            }
            if (newworld.func_175625_s(newte.func_174877_v()) != newte) {
                Log.info("Tried to add invalid (world disagrees) conduit to network: ", newconduit);
                error = true;
            }
        }
        if (error) {
            new Exception("trace for message above").printStackTrace();
            return;
        }
        ArrayList<I> old = new ArrayList<I>(this.conduits);
        this.conduits.clear();
        for (IConduit oldconduit : old) {
            BlockPos oldpos;
            if (newconduit == oldconduit) continue;
            IConduitBundle oldbundle = oldconduit.getBundle();
            TileEntity oldte = oldbundle.getEntity();
            if (oldte == null || oldte.func_145837_r() || !oldte.func_145830_o()) {
                oldconduit.setNetwork(null);
                continue;
            }
            World oldworld = oldbundle.getBundleWorldObj();
            if (!oldworld.func_175667_e(oldpos = oldte.func_174877_v())) {
                Log.info("Removed unloaded but valid conduit from network: " + oldconduit);
                oldconduit.setNetwork(null);
                continue;
            }
            if (oldworld.func_175625_s(oldpos) != oldte) {
                oldconduit.setNetwork(null);
                continue;
            }
            if (newpos != null && newpos.equals((Object)oldpos)) {
                Log.info("Tried to add invalid conduit to network! Old conduit: ", oldconduit, "/", oldbundle, " New conduit: ", newconduit, "/", oldbundle, " World says: ", oldworld.func_175625_s(newpos));
                newconduit = null;
            }
            this.conduits.add(oldconduit);
        }
        if (newconduit != null) {
            this.conduits.add(newconduit);
        }
    }

    public void destroyNetwork() {
        for (IConduit con : this.conduits) {
            con.setNetwork(null);
        }
        this.conduits.clear();
        ConduitNetworkTickHandler.instance.unregisterNetwork(this);
    }

    public List<I> getConduits() {
        return this.conduits;
    }

    public void sendBlockUpdatesForEntireNetwork() {
        ConduitNeighborUpdateTracker tracker = null;
        HashSet<BlockPos> notified = new HashSet<BlockPos>();
        for (IConduit con : this.conduits) {
            TileEntity te = con.getBundle().getEntity();
            if (!con.hasExternalConnections()) continue;
            BlockPos pos = te.func_174877_v();
            Block blockType = te.func_145838_q();
            World world = te.func_145831_w();
            if (!world.func_175667_e(pos)) continue;
            IBlockState bs = world.func_180495_p(pos);
            if (tracker == null) {
                tracker = new ConduitNeighborUpdateTracker("Conduit network " + this.getClass() + " was interrupted while notifying neighbors of changes");
            }
            tracker.start("World.notifyBlockUpdate() at " + pos);
            world.func_184138_a(pos, bs, bs, 3);
            tracker.stop();
            EnumSet<EnumFacing> sidesToNotify = EnumSet.noneOf(EnumFacing.class);
            for (EnumFacing side : WEDUNS) {
                IBlockState blockState;
                BlockPos offset = pos.func_177972_a(side);
                if (!con.containsExternalConnection(side) || notified.contains(offset) || !world.func_175667_e(offset) || (blockState = world.func_180495_p(offset)).func_177230_c() == blockType || blockState.func_177230_c() == Blocks.field_150350_a) continue;
                sidesToNotify.add(side);
                notified.add(offset);
            }
            if (sidesToNotify.isEmpty()) continue;
            tracker.start("ForgeEventFactory.onNeighborNotify() at " + pos);
            boolean canceled = ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)bs, sidesToNotify).isCanceled();
            tracker.stop();
            if (canceled) continue;
            for (EnumFacing side : WEDUNS) {
                if (!sidesToNotify.contains(side)) continue;
                BlockPos offset = pos.func_177972_a(side);
                tracker.start("World.notifyNeighborsOfStateChange() from " + pos + " to " + offset + " (" + world.func_180495_p(offset) + ")");
                world.func_180496_d(offset, blockType);
                tracker.stop();
            }
        }
        if (tracker != null) {
            tracker.discard();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IConduit con : this.conduits) {
            sb.append(con.getLocation());
            sb.append(", ");
        }
        return "AbstractConduitNetwork@" + Integer.toHexString(this.hashCode()) + " [conduits=" + sb.toString() + "]";
    }

    public void doNetworkTick(Profiler theProfiler) {
    }
}

