/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.render.IBlockStateWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractConduit
implements IConduit {
    protected final Set<EnumFacing> conduitConnections = EnumSet.noneOf(EnumFacing.class);
    protected final Set<EnumFacing> externalConnections = EnumSet.noneOf(EnumFacing.class);
    public static final float STUB_WIDTH = 0.2f;
    public static final float STUB_HEIGHT = 0.2f;
    public static final float TRANSMISSION_SCALE = 0.3f;
    protected IConduitBundle bundle;
    protected boolean active;
    protected List<CollidableComponent> collidables;
    protected final EnumMap<EnumFacing, ConnectionMode> conectionModes = new EnumMap(EnumFacing.class);
    protected boolean collidablesDirty = true;
    private boolean clientStateDirty = true;
    private boolean dodgyChangeSinceLastCallFlagForBundle = true;
    protected boolean connectionsDirty = true;
    protected boolean readFromNbt = false;
    private Integer lastExternalRedstoneLevel = null;

    protected AbstractConduit() {
    }

    @Override
    public boolean writeConnectionSettingsToNBT(EnumFacing dir, NBTTagCompound nbt) {
        if (!this.getExternalConnections().contains(dir)) {
            return false;
        }
        NBTTagCompound dataRoot = this.getNbtRootForType(nbt, true);
        dataRoot.func_74777_a("connectionMode", (short)this.getConnectionMode(dir).ordinal());
        this.writeTypeSettingsToNbt(dir, dataRoot);
        return true;
    }

    @Override
    public boolean readConduitSettingsFromNBT(EnumFacing dir, NBTTagCompound nbt) {
        if (!this.getExternalConnections().contains(dir)) {
            return false;
        }
        NBTTagCompound dataRoot = this.getNbtRootForType(nbt, false);
        if (dataRoot == null) {
            return false;
        }
        if (dataRoot.func_74764_b("connectionMode")) {
            ConnectionMode mode = ConnectionMode.values()[dataRoot.func_74765_d("connectionMode")];
            this.setConnectionMode(dir, mode);
        }
        this.readTypeSettings(dir, dataRoot);
        return true;
    }

    protected void readTypeSettings(EnumFacing dir, NBTTagCompound dataRoot) {
    }

    protected void writeTypeSettingsToNbt(EnumFacing dir, NBTTagCompound dataRoot) {
    }

    protected NBTTagCompound getNbtRootForType(NBTTagCompound nbt, boolean createIfNull) {
        Class<? extends IConduit> bt = this.getBaseConduitType();
        String dataRootName = bt.getSimpleName();
        NBTTagCompound dataRoot = null;
        if (nbt.func_74764_b(dataRootName)) {
            dataRoot = nbt.func_74775_l(dataRootName);
        }
        if (dataRoot == null && createIfNull) {
            dataRoot = new NBTTagCompound();
            nbt.func_74782_a(dataRootName, (NBTBase)dataRoot);
        }
        return dataRoot;
    }

    @Override
    public ConnectionMode getConnectionMode(EnumFacing dir) {
        ConnectionMode res = this.conectionModes.get(dir);
        if (res == null) {
            return this.getDefaultConnectionMode();
        }
        return res;
    }

    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.IN_OUT;
    }

    @Override
    public List<ItemStack> getDrops() {
        return Collections.singletonList(this.createItem());
    }

    @Override
    public void setConnectionMode(EnumFacing dir, ConnectionMode mode) {
        ConnectionMode oldVal = this.conectionModes.get(dir);
        if (oldVal == mode) {
            return;
        }
        if (mode == null) {
            this.conectionModes.remove(dir);
        } else {
            this.conectionModes.put(dir, mode);
        }
        this.connectionsChanged();
    }

    @Override
    public boolean hasConnectionMode(ConnectionMode mode) {
        if (mode == null) {
            return false;
        }
        if (mode == this.getDefaultConnectionMode() && this.conectionModes.size() != 6) {
            return true;
        }
        for (ConnectionMode cm : this.conectionModes.values()) {
            if (cm != mode) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConnectionMode getNextConnectionMode(EnumFacing dir) {
        ConnectionMode curMode = this.getConnectionMode(dir);
        ConnectionMode next = ConnectionMode.getNext(curMode);
        if (next == ConnectionMode.NOT_SET) {
            next = ConnectionMode.IN_OUT;
        }
        return next;
    }

    @Override
    public ConnectionMode getPreviousConnectionMode(EnumFacing dir) {
        ConnectionMode curMode = this.getConnectionMode(dir);
        ConnectionMode prev = ConnectionMode.getPrevious(curMode);
        if (prev == ConnectionMode.NOT_SET) {
            prev = ConnectionMode.DISABLED;
        }
        return prev;
    }

    @Override
    public boolean haveCollidablesChangedSinceLastCall() {
        if (this.dodgyChangeSinceLastCallFlagForBundle) {
            this.dodgyChangeSinceLastCallFlagForBundle = false;
            return true;
        }
        return false;
    }

    @Override
    public BlockCoord getLocation() {
        if (this.bundle == null) {
            return null;
        }
        return this.bundle.getLocation();
    }

    @Override
    public void setBundle(IConduitBundle tileConduitBundle) {
        this.bundle = tileConduitBundle;
    }

    @Override
    public IConduitBundle getBundle() {
        return this.bundle;
    }

    @Override
    public Set<EnumFacing> getConduitConnections() {
        return this.conduitConnections;
    }

    @Override
    public boolean containsConduitConnection(EnumFacing dir) {
        return this.conduitConnections.contains(dir);
    }

    @Override
    public void conduitConnectionAdded(EnumFacing fromDirection) {
        this.conduitConnections.add(fromDirection);
    }

    @Override
    public void conduitConnectionRemoved(EnumFacing fromDirection) {
        this.conduitConnections.remove(fromDirection);
    }

    @Override
    public boolean canConnectToConduit(EnumFacing direction, IConduit conduit) {
        if (conduit == null) {
            return false;
        }
        return this.getConnectionMode(direction) != ConnectionMode.DISABLED && conduit.getConnectionMode(direction.func_176734_d()) != ConnectionMode.DISABLED;
    }

    @Override
    public boolean canConnectToExternal(EnumFacing direction, boolean ignoreConnectionMode) {
        return false;
    }

    @Override
    public Set<EnumFacing> getExternalConnections() {
        return this.externalConnections;
    }

    @Override
    public boolean hasExternalConnections() {
        return !this.externalConnections.isEmpty();
    }

    @Override
    public boolean hasConnections() {
        return this.hasConduitConnections() || this.hasExternalConnections();
    }

    @Override
    public boolean hasConduitConnections() {
        return !this.conduitConnections.isEmpty();
    }

    @Override
    public boolean containsExternalConnection(EnumFacing dir) {
        return this.externalConnections.contains(dir);
    }

    @Override
    public void externalConnectionAdded(EnumFacing fromDirection) {
        this.externalConnections.add(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(EnumFacing fromDirection) {
        this.externalConnections.remove(fromDirection);
    }

    @Override
    public boolean isConnectedTo(EnumFacing dir) {
        return this.containsConduitConnection(dir) || this.containsExternalConnection(dir);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.active) {
            this.clientStateDirty = true;
        }
        this.active = active;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        int i;
        int[] dirs = new int[this.conduitConnections.size()];
        Iterator<EnumFacing> cons = this.conduitConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = cons.next().ordinal();
        }
        nbtRoot.func_74783_a("connections", dirs);
        dirs = new int[this.externalConnections.size()];
        cons = this.externalConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = cons.next().ordinal();
        }
        nbtRoot.func_74783_a("externalConnections", dirs);
        nbtRoot.func_74757_a("signalActive", this.active);
        if (this.conectionModes.size() > 0) {
            byte[] modes = new byte[6];
            int i2 = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                modes[i2] = (byte)this.getConnectionMode(dir).ordinal();
                ++i2;
            }
            nbtRoot.func_74773_a("conModes", modes);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        int i;
        this.conduitConnections.clear();
        int[] dirs = nbtRoot.func_74759_k("connections");
        for (i = 0; i < dirs.length; ++i) {
            this.conduitConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.externalConnections.clear();
        dirs = nbtRoot.func_74759_k("externalConnections");
        for (i = 0; i < dirs.length; ++i) {
            this.externalConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.active = nbtRoot.func_74767_n("signalActive");
        this.conectionModes.clear();
        byte[] modes = nbtRoot.func_74770_j("conModes");
        if (modes != null && modes.length == 6) {
            int i2 = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.conectionModes.put(dir, ConnectionMode.values()[modes[i2]]);
                ++i2;
            }
        }
        this.readFromNbt = true;
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, RaytraceResult res, List<RaytraceResult> all) {
        return false;
    }

    @Override
    public float getSelfIlluminationForState(CollidableComponent component) {
        return this.isActive() ? 1.0f : 0.0f;
    }

    @Override
    public float getTransmitionGeometryScale() {
        return 0.3f;
    }

    @Override
    public void onChunkUnload(World worldObj) {
        AbstractConduitNetwork<?, ?> network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
    }

    @Override
    public void updateEntity(World world) {
        if (world.field_72995_K) {
            return;
        }
        this.updateNetwork(world);
        this.updateConnections();
        this.readFromNbt = false;
        if (this.clientStateDirty && this.getBundle() != null) {
            this.getBundle().dirty();
            this.clientStateDirty = false;
        }
    }

    private void updateConnections() {
        if (!this.connectionsDirty && !this.readFromNbt) {
            return;
        }
        boolean externalConnectionsChanged = false;
        ArrayList<EnumFacing> copy = new ArrayList<EnumFacing>(this.externalConnections);
        for (EnumFacing dir : copy) {
            if (this.canConnectToExternal(dir, false) && !this.readFromNbt) continue;
            this.externalConnectionRemoved(dir);
            externalConnectionsChanged = true;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.conduitConnections.contains(dir) || this.externalConnections.contains(dir) || !this.canConnectToExternal(dir, false)) continue;
            this.externalConnectionAdded(dir);
            externalConnectionsChanged = true;
        }
        if (externalConnectionsChanged) {
            this.connectionsChanged();
        }
        this.connectionsDirty = false;
    }

    @Override
    public void connectionsChanged() {
        this.collidablesDirty = true;
        this.clientStateDirty = true;
        this.dodgyChangeSinceLastCallFlagForBundle = true;
    }

    protected void setClientStateDirty() {
        this.clientStateDirty = true;
    }

    protected void updateNetwork(World world) {
        BlockCoord pos = this.getLocation();
        if (this.getNetwork() == null && world.func_175667_e(pos.getBlockPos())) {
            ConduitUtil.ensureValidNetwork(this);
            if (this.getNetwork() != null) {
                this.getNetwork().sendBlockUpdatesForEntireNetwork();
                if (this.readFromNbt) {
                    this.connectionsChanged();
                }
            }
        }
    }

    @Override
    public void onAddedToBundle() {
        TileEntity te = this.bundle.getEntity();
        World world = te.func_145831_w();
        this.conduitConnections.clear();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IConduit neighbour = ConduitUtil.getConduit(world, te, dir, this.getBaseConduitType());
            if (neighbour == null || !neighbour.canConnectToConduit(dir.func_176734_d(), this)) continue;
            this.conduitConnections.add(dir);
            neighbour.conduitConnectionAdded(dir.func_176734_d());
            neighbour.connectionsChanged();
        }
        this.externalConnections.clear();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.containsConduitConnection(dir) || !this.canConnectToExternal(dir, false)) continue;
            this.externalConnectionAdded(dir);
        }
        this.connectionsChanged();
    }

    @Override
    public void onRemovedFromBundle() {
        TileEntity te = this.bundle.getEntity();
        World world = te.func_145831_w();
        for (EnumFacing dir : this.conduitConnections) {
            IConduit neighbour = ConduitUtil.getConduit(world, te, dir, this.getBaseConduitType());
            if (neighbour == null) continue;
            neighbour.conduitConnectionRemoved(dir.func_176734_d());
            neighbour.connectionsChanged();
        }
        this.conduitConnections.clear();
        if (!this.externalConnections.isEmpty()) {
            world.func_175685_c(te.func_174877_v(), te.func_145838_q());
        }
        this.externalConnections.clear();
        AbstractConduitNetwork<?, ?> network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
        this.connectionsChanged();
    }

    @Override
    public boolean onNeighborBlockChange(Block block) {
        if (block == ModObject.blockConduitBundle.getBlock()) {
            return false;
        }
        this.lastExternalRedstoneLevel = null;
        EnumSet<EnumFacing> newCons = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.containsConduitConnection(dir) || !this.canConnectToExternal(dir, false)) continue;
            newCons.add(dir);
        }
        if (newCons.size() != this.externalConnections.size()) {
            this.connectionsDirty = true;
            return true;
        }
        for (EnumFacing dir : this.externalConnections) {
            if (newCons.remove(dir)) continue;
            this.connectionsDirty = true;
            return true;
        }
        if (!newCons.isEmpty()) {
            this.connectionsDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbourPos) {
        return false;
    }

    @Override
    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey key) {
        return Collections.singletonList(new CollidableComponent(this.getCollidableType(), ConduitGeometryUtil.instance.getBoundingBox(this.getBaseConduitType(), key.dir, key.isStub, key.offset), key.dir, null));
    }

    @Override
    public Class<? extends IConduit> getCollidableType() {
        return this.getBaseConduitType();
    }

    public List<CollidableComponent> getCollidableComponents() {
        if (this.collidables != null && !this.collidablesDirty) {
            return this.collidables;
        }
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Collection<CollidableComponent> col = this.getCollidables(dir);
            if (col == null) continue;
            result.addAll(col);
        }
        this.collidables = result;
        this.collidablesDirty = false;
        return result;
    }

    protected boolean renderStub(EnumFacing dir) {
        return false;
    }

    private Collection<CollidableComponent> getCollidables(EnumFacing dir) {
        CollidableCache cc = CollidableCache.instance;
        Class<? extends IConduit> type = this.getCollidableType();
        if (this.isConnectedTo(dir) && this.getConnectionMode(dir) != ConnectionMode.DISABLED) {
            return cc.getCollidables(cc.createKey(type, this.getBundle().getOffset(this.getBaseConduitType(), dir), dir, this.renderStub(dir)), this);
        }
        return null;
    }

    @Override
    public boolean shouldMirrorTexture() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(IBlockStateWrapper wrapper, BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        hashCodes.add(this.getClass());
        hashCodes.add(this.conduitConnections, this.externalConnections, this.conectionModes);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public int getExternalRedstoneLevel() {
        if (this.lastExternalRedstoneLevel == null) {
            if (this.bundle == null || this.bundle.getEntity() == null) {
                return 0;
            }
            TileEntity te = this.bundle.getEntity();
            this.lastExternalRedstoneLevel = ConduitUtil.isBlockIndirectlyGettingPoweredIfLoaded(te.func_145831_w(), te.func_174877_v());
        }
        return this.lastExternalRedstoneLevel;
    }

    public String toString() {
        return "AbstractConduit [getClass()=" + this.getClass() + ", lastExternalRedstoneLevel=" + this.lastExternalRedstoneLevel + ", getConduitConnections()=" + this.getConduitConnections() + ", getExternalConnections()=" + this.getExternalConnections() + ", getNetwork()=" + this.getNetwork() + "]";
    }
}

