/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import omtteam.omlib.api.IDebugTile;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.tileentity.ICamoSupport;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.util.BlockUtil;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.omlib.util.WorldUtil;
import omtteam.omlib.util.compat.ItemStackList;
import omtteam.omlib.util.compat.ItemStackTools;
import omtteam.openmodularturrets.compatability.ModCompatibility;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.items.AddonMetaItem;
import omtteam.openmodularturrets.items.UpgradeMetaItem;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.OMTUtil;
import omtteam.openmodularturrets.util.TurretHeadUtil;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TurretBase
extends TileEntityMachine
implements ICamoSupport,
IDebugTile {
    public int trustedPlayerIndex = 0;
    protected IBlockState camoBlockState;
    public boolean shouldConcealTurrets;
    private boolean multiTargeting = false;
    private int currentMaxRange;
    private int upperBoundMaxRange;
    private boolean rangeOverridden;
    private boolean attacksMobs;
    private boolean attacksNeutrals;
    private boolean attacksPlayers;
    private int ticks;
    private boolean computerAccessible = false;
    protected int tier;
    private boolean forceFire = false;

    public TurretBase() {
        this.inventory = ItemStackList.create((int)13);
    }

    public TurretBase(int MaxEnergyStorage, int MaxIO, int tier, IBlockState camoState) {
        this.currentMaxRange = 0;
        this.upperBoundMaxRange = 0;
        this.rangeOverridden = false;
        this.storage = new OMEnergyStorage(MaxEnergyStorage, MaxIO);
        this.attacksMobs = true;
        this.attacksNeutrals = true;
        this.attacksPlayers = false;
        this.inventory = ItemStackList.create((int)(tier == 5 ? 13 : (tier == 4 ? 12 : (tier == 3 ? 12 : (tier == 2 ? 12 : 9)))));
        this.tier = tier;
        this.camoBlockState = camoState;
    }

    public IBlockState getDefaultCamoState() {
        return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("openmodularturrets:turret_base"))).func_176203_a(this.tier - 1);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("currentMaxRange", this.currentMaxRange);
        nbtTagCompound.func_74768_a("upperBoundMaxRange", this.upperBoundMaxRange);
        nbtTagCompound.func_74757_a("rangeOverridden", this.rangeOverridden);
        nbtTagCompound.func_74757_a("attacksMobs", this.attacksMobs);
        nbtTagCompound.func_74757_a("attacksNeutrals", this.attacksNeutrals);
        nbtTagCompound.func_74757_a("attacksPlayers", this.attacksPlayers);
        nbtTagCompound.func_74757_a("computerAccessible", this.computerAccessible);
        nbtTagCompound.func_74757_a("shouldConcealTurrets", this.shouldConcealTurrets);
        nbtTagCompound.func_74757_a("multiTargeting", this.multiTargeting);
        nbtTagCompound.func_74757_a("forceFire", this.forceFire);
        nbtTagCompound.func_74768_a("tier", this.tier);
        BlockUtil.writeBlockFromStateToNBT((NBTTagCompound)nbtTagCompound, (IBlockState)this.camoBlockState);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.currentMaxRange = nbtTagCompound.func_74762_e("currentMaxRange");
        this.upperBoundMaxRange = nbtTagCompound.func_74762_e("upperBoundMaxRange");
        this.rangeOverridden = nbtTagCompound.func_74767_n("rangeOverridden");
        this.attacksMobs = nbtTagCompound.func_74767_n("attacksMobs");
        this.attacksNeutrals = nbtTagCompound.func_74767_n("attacksNeutrals");
        this.attacksPlayers = nbtTagCompound.func_74767_n("attacksPlayers");
        this.shouldConcealTurrets = nbtTagCompound.func_74767_n("shouldConcealTurrets");
        this.multiTargeting = nbtTagCompound.func_74767_n("multiTargeting");
        this.forceFire = nbtTagCompound.func_74767_n("forceFire");
        this.tier = nbtTagCompound.func_74762_e("tier");
        this.computerAccessible = nbtTagCompound.func_74764_b("computerAccessible") && nbtTagCompound.func_74767_n("computerAccessible");
        this.camoBlockState = BlockUtil.getBlockStateFromNBT((NBTTagCompound)nbtTagCompound) != null ? BlockUtil.getBlockStateFromNBT((NBTTagCompound)nbtTagCompound) : this.getDefaultCamoState();
    }

    public void setCurrentMaxRange(int newCurrentMaxRange) {
        this.currentMaxRange = newCurrentMaxRange;
        this.rangeOverridden = true;
        if (this.currentMaxRange > this.upperBoundMaxRange) {
            this.currentMaxRange = this.upperBoundMaxRange;
        }
        if (this.currentMaxRange < 0) {
            this.currentMaxRange = 0;
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.dropBlock) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
            return;
        }
        ++this.ticks;
        if (!this.func_145831_w().field_72995_K && this.ticks % 5 == 0) {
            this.setBaseUpperBoundRange();
            if (this.currentMaxRange > this.upperBoundMaxRange) {
                this.currentMaxRange = this.upperBoundMaxRange;
            }
            if (!this.rangeOverridden) {
                this.currentMaxRange = this.upperBoundMaxRange;
            }
            this.shouldConcealTurrets = TurretHeadUtil.hasConcealmentAddon(this);
            this.storage.setCapacity(this.getMaxEnergyStorageWithExtenders());
            if (this.ticks % 20 == 0) {
                this.ticks = 0;
                TurretBase.updateRedstoneReactor(this);
                this.computerAccessible = (ModCompatibility.OpenComputersLoaded || ModCompatibility.ComputerCraftLoaded) && TurretHeadUtil.hasSerialPortAddon(this);
            }
        }
    }

    private void setBaseUpperBoundRange() {
        int maxRange = this.upperBoundMaxRange;
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        for (TileEntity te : tileEntities) {
            if (te == null || !(te instanceof TurretHead)) continue;
            maxRange = Math.max(((TurretHead)te).getTurretRange() + TurretHeadUtil.getRangeUpgrades(this), maxRange);
        }
        this.upperBoundMaxRange = maxRange;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i < 9) {
            return OMTUtil.isItemStackValidAmmo(stack);
        }
        if (i >= 9 && i <= 10) {
            return stack.func_77973_b() instanceof AddonMetaItem;
        }
        if (i >= 11 && i <= 12) {
            return stack.func_77973_b() instanceof UpgradeMetaItem;
        }
        return false;
    }

    public boolean isAttacksMobs() {
        return this.attacksMobs;
    }

    public void setAttacksMobs(boolean attacksMobs) {
        this.attacksMobs = attacksMobs;
    }

    public boolean isAttacksNeutrals() {
        return this.attacksNeutrals;
    }

    public void setAttacksNeutrals(boolean attacksNeutrals) {
        this.attacksNeutrals = attacksNeutrals;
    }

    public boolean isAttacksPlayers() {
        return this.attacksPlayers;
    }

    public void setAttacksPlayers(boolean attacksPlayers) {
        this.attacksPlayers = attacksPlayers;
    }

    public boolean isMultiTargeting() {
        return this.multiTargeting;
    }

    public void setMultiTargeting(boolean multiTargeting) {
        this.multiTargeting = multiTargeting;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setAllTurretsYawPitch(float yaw, float pitch) {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        for (TileEntity te : tileEntities) {
            if (te == null || !(te instanceof TurretHead)) continue;
            ((TurretHead)te).setRotationXY(MathUtil.getRotationXYFromYawPitch((float)yaw, (float)pitch));
            ((TurretHead)te).setRotationXZ(MathUtil.getRotationXZFromYawPitch((float)yaw, (float)pitch));
        }
    }

    public boolean setTurretYawPitch(EnumFacing facing, float yaw, float pitch) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (turretHead != null && turretHead instanceof TurretHead) {
            ((TurretHead)turretHead).setRotationXY(MathUtil.getRotationXYFromYawPitch((float)yaw, (float)pitch));
            ((TurretHead)turretHead).setRotationXZ(MathUtil.getRotationXZFromYawPitch((float)yaw, (float)pitch));
            return true;
        }
        return false;
    }

    public void setAllTurretsForceFire(boolean state) {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        for (TileEntity te : tileEntities) {
            if (te == null || !(te instanceof TurretHead)) continue;
            ((TurretHead)te).setAutoFire(state);
        }
    }

    public boolean setTurretForceFire(EnumFacing facing, boolean state) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (turretHead != null && turretHead instanceof TurretHead) {
            ((TurretHead)turretHead).setAutoFire(state);
            return true;
        }
        return false;
    }

    public boolean forceShootTurret(EnumFacing facing) {
        TileEntity turretHead = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
        return turretHead != null && turretHead instanceof TurretHead && ((TurretHead)turretHead).forceShot();
    }

    public int forceShootAllTurrets() {
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.func_145831_w(), (BlockPos)this.field_174879_c);
        int successes = 0;
        for (TileEntity te : tileEntities) {
            if (te == null || !(te instanceof TurretHead)) continue;
            successes += ((TurretHead)te).forceShot() ? 1 : 0;
        }
        return successes;
    }

    public NBTTagCompound writeMemoryCardNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74757_a("inverted", this.inverted);
        nbtTagCompound.func_74768_a("currentMaxRange", this.currentMaxRange);
        nbtTagCompound.func_74757_a("attacksMobs", this.attacksMobs);
        nbtTagCompound.func_74757_a("attacksNeutrals", this.attacksNeutrals);
        nbtTagCompound.func_74757_a("attacksPlayers", this.attacksPlayers);
        nbtTagCompound.func_74757_a("multiTargeting", this.multiTargeting);
        nbtTagCompound.func_74782_a("trustedPlayers", (NBTBase)this.getTrustedPlayersAsNBT());
        return nbtTagCompound;
    }

    public void readMemoryCardNBT(NBTTagCompound nbtTagCompound) {
        this.currentMaxRange = nbtTagCompound.func_74762_e("currentMaxRange");
        this.attacksMobs = nbtTagCompound.func_74767_n("attacksMobs");
        this.attacksNeutrals = nbtTagCompound.func_74767_n("attacksNeutrals");
        this.attacksPlayers = nbtTagCompound.func_74767_n("attacksPlayers");
        this.multiTargeting = nbtTagCompound.func_74767_n("multiTargeting");
        this.setInverted(nbtTagCompound.func_74767_n("inverted"));
        this.buildTrustedPlayersFromNBT(nbtTagCompound.func_150295_c("trustedPlayers", 10));
    }

    private static void updateRedstoneReactor(TurretBase base) {
        OMEnergyStorage storage = (OMEnergyStorage)base.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (!TurretHeadUtil.hasRedstoneReactor(base) || storage == null) {
            return;
        }
        if (ConfigHandler.getRedstoneReactorAddonGen() < storage.getMaxEnergyStored() - storage.getEnergyStored()) {
            ItemStack redstoneBlock = TurretHeadUtil.getSpecificItemStackBlockFromBase(base, new ItemStack(Blocks.field_150451_bX));
            if (redstoneBlock == ItemStackTools.getEmptyStack()) {
                redstoneBlock = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Blocks.field_150451_bX), base);
            }
            if (redstoneBlock != ItemStackTools.getEmptyStack() && ConfigHandler.getRedstoneReactorAddonGen() * 9 < storage.getMaxEnergyStored() - storage.getEnergyStored()) {
                base.storage.modifyEnergyStored(ConfigHandler.getRedstoneReactorAddonGen() * 9);
                return;
            }
            ItemStack redstone = TurretHeadUtil.getSpecificItemStackItemFromBase(base, new ItemStack(Items.field_151137_ax));
            if (redstone == ItemStackTools.getEmptyStack()) {
                redstone = TurretHeadUtil.getSpecificItemFromInvExpanders(base.func_145831_w(), new ItemStack(Items.field_151137_ax), base);
            }
            if (redstone != ItemStackTools.getEmptyStack()) {
                storage.modifyEnergyStored(ConfigHandler.getRedstoneReactorAddonGen());
            }
        }
    }

    private int getMaxEnergyStorageWithExtenders() {
        int tier = this.getTier();
        switch (tier) {
            case 1: {
                return ConfigHandler.getBaseTierOneMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 2: {
                return ConfigHandler.getBaseTierTwoMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 3: {
                return ConfigHandler.getBaseTierThreeMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 4: {
                return ConfigHandler.getBaseTierFourMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
            case 5: {
                return ConfigHandler.getBaseTierFiveMaxCharge() + TurretHeadUtil.getPowerExpanderTotalExtraCapacity(this.func_145831_w(), this.field_174879_c);
            }
        }
        return 0;
    }

    public int getCurrentMaxRange() {
        return this.currentMaxRange;
    }

    public int getUpperBoundMaxRange() {
        return this.upperBoundMaxRange;
    }

    @Nonnull
    public IBlockState getCamoState() {
        return this.camoBlockState != null ? this.camoBlockState : this.getDefaultCamoState();
    }

    public void setCamoState(IBlockState state) {
        this.camoBlockState = state;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @ParametersAreNonnullByDefault
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180461_b(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():string; returns owner of turret base.")
    public Object[] getOwner(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getOwner()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack hostile mobs.")
    public Object[] isAttacksMobs(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksMobs()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(state:boolean):boolean;  sets to attack hostile mobs or not.")
    public Object[] setAttacksMobs(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksMobs(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack neutral mobs.")
    public Object[] isAttacksNeutrals(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksNeutrals()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(state:boolean):boolean; sets to attack neutral mobs or not.")
    public Object[] setAttacksNeutrals(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksNeutrals(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently set to attack players.")
    public Object[] isAttacksPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isAttacksPlayers()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(state:boolean):boolean; sets to attack players or not.")
    public Object[] setAttacksPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setAttacksPlayers(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():table; returns a table of trusted players on this base.")
    public Object[] getTrustedPlayers(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getTrustedPlayers()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(name:String, [canOpenGUI:boolean , canChangeTargeting:boolean , admin:boolean]):string; adds Trusted player to Trustlist.")
    public Object[] addTrustedPlayer(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!this.addTrustedPlayer(args.checkString(0))) {
            return new Object[]{"Name not valid!"};
        }
        TrustedPlayer trustedPlayer = this.getTrustedPlayer(args.checkString(0));
        trustedPlayer.canOpenGUI = args.optBoolean(1, false);
        trustedPlayer.canChangeTargeting = args.optBoolean(1, false);
        trustedPlayer.admin = args.optBoolean(1, false);
        trustedPlayer.uuid = PlayerUtil.getPlayerUUID((String)args.checkString(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(name:String):string; removes trusted player from trust list.")
    public Object[] removeTrustedPlayer(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.removeTrustedPlayer(args.checkString(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():int; returns maximum energy storage.")
    public Object[] getMaxEnergyStorage(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.storage.getMaxEnergyStored()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():int; returns current energy stored.")
    public Object[] getCurrentEnergyStorage(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getEnergyLevel(EnumFacing.DOWN)};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; returns if the turret is currently active.")
    public Object[] getActive(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.isActive()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(state:boolean):boolean; toggles turret redstone inversion state.")
    public Object[] setInverted(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        this.setInverted(args.checkBoolean(0));
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; shows redstone inversion state.")
    public Object[] getInverted(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getInverted()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():boolean; shows redstone state.")
    public Object[] getRedstone(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.getRedstone()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(side:int, yaw:double, pitch:double):void; Set yaw and pitch for all turrets (deact. auto targ. before).")
    public Object[] setAllYawPitch(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isDouble(0) || !args.isDouble(1)) {
            return new Object[]{"Wrong parameters!"};
        }
        this.setAllTurretsYawPitch((float)args.checkDouble(0), (float)args.checkDouble(1));
        return new Object[0];
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(yaw:double, pitch:double):boolean; Set yaw and pitch for a turret (deact. auto targ. before).")
    public Object[] setTurretYawPitch(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isInteger(0) && args.checkInteger(0) <= 6 && args.checkInteger(0) >= 0 && !args.isDouble(1) || !args.isDouble(2)) {
            return new Object[]{"Wrong parameters!"};
        }
        return new Object[]{this.setTurretYawPitch(EnumFacing.func_82600_a((int)args.checkInteger(0)), (float)args.checkDouble(0), (float)args.checkDouble(1))};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(state:boolean):void; Enable auto firing for all Turrets (deact. auto targ. before).")
    public Object[] setAllAutoForceFire(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isBoolean(0)) {
            return new Object[]{"Wrong parameters!"};
        }
        this.setAllTurretsForceFire(args.checkBoolean(0));
        return new Object[0];
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(state:boolean):boolean; Enable auto firing for specified Turret (deact. auto targ. before).")
    public Object[] setTurretAutoForceFire(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isInteger(0) && args.checkInteger(0) <= 6 && args.checkInteger(0) >= 0 && !args.isBoolean(1)) {
            return new Object[]{"Wrong parameters!"};
        }
        return new Object[]{this.setTurretForceFire(EnumFacing.func_82600_a((int)args.checkInteger(0)), args.checkBoolean(1))};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():int; Try to shoot all turrets, returns successful shots")
    public Object[] forceShootAll(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        return new Object[]{this.forceShootAllTurrets()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(side:int):boolean; Try to shoot specified turret, returns true if successfully shot")
    public Object[] forceShootTurret(Context context, Arguments args) {
        if (!this.computerAccessible) {
            return new Object[]{"Computer access deactivated!"};
        }
        if (!args.isInteger(0) && args.checkInteger(0) <= 6 && args.checkInteger(0) >= 0) {
            return new Object[]{"Wrong parameters!"};
        }
        return new Object[]{this.forceShootTurret(EnumFacing.func_82600_a((int)args.checkInteger(0)))};
    }

    public List<String> getDebugInfo() {
        ArrayList<String> debugInfo = new ArrayList<String>();
        debugInfo.add("Camo: " + this.camoBlockState.func_177230_c().getRegistryName() + ", computerAccess: " + this.computerAccessible);
        debugInfo.add("Force Fire: " + this.forceFire + ", UpperMaxRange: " + this.upperBoundMaxRange);
        return debugInfo;
    }
}

