/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import omtteam.omlib.tileentity.TileEntityContainer;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.compat.ItemStackList;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public class Expander
extends TileEntityContainer
implements ITickable {
    protected TurretBase base;
    private boolean powerExpander;
    private EnumFacing orientation;
    private int tier;

    public Expander() {
        this.inventory = ItemStackList.create((int)9);
        this.orientation = EnumFacing.NORTH;
    }

    public Expander(int tier, boolean powerExpander) {
        this.inventory = ItemStackList.create((int)9);
        this.tier = tier;
        this.powerExpander = powerExpander;
        this.orientation = EnumFacing.NORTH;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("powerExpander", this.powerExpander);
        nbtTagCompound.func_74774_a("direction", (byte)this.orientation.ordinal());
        nbtTagCompound.func_74768_a("tier", this.tier);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.powerExpander = nbtTagCompound.func_74767_n("powerExpander");
        this.tier = nbtTagCompound.func_74762_e("tier");
        if (nbtTagCompound.func_74764_b("direction")) {
            this.setOrientation(EnumFacing.func_82600_a((int)nbtTagCompound.func_74771_c("direction")));
        }
    }

    public int func_70297_j_() {
        return MathUtil.truncateDoubleToInt((double)Math.pow(2.0, this.tier + 1));
    }

    public void setSide() {
        this.setOrientation(TurretHeadUtil.getTurretBaseFacing(this.func_145831_w(), this.field_174879_c));
    }

    public void func_73660_a() {
        if (this.func_145831_w().func_72820_D() % 15L == 0L && this.getBase() == null || this.dropBlock) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return !this.isPowerExpander();
    }

    public int getTier() {
        return this.tier;
    }

    public TurretBase getBase() {
        return TurretHeadUtil.getTurretBase(this.func_145831_w(), this.field_174879_c);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean isPowerExpander() {
        return this.powerExpander;
    }

    public EnumFacing getOrientation() {
        return this.orientation;
    }

    private void setOrientation(EnumFacing orientation) {
        this.orientation = orientation;
    }
}

