/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class RocketProjectile
extends TurretProjectile {
    public int arrowShake;
    private Entity target;

    public RocketProjectile(World par1World) {
        super(par1World);
        this.gravity = 0.0f;
    }

    public RocketProjectile(World p_i1776_1_, TurretBase turretBase) {
        super(p_i1776_1_, turretBase);
        this.gravity = 0.0f;
    }

    public RocketProjectile(World par1World, Entity target, ItemStack ammo, TurretBase turretBase) {
        super(par1World, ammo, turretBase);
        this.gravity = 0.0f;
        this.target = target;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.func_130014_f_().field_72995_K) {
            if (ConfigHandler.canRocketsHome && this.target != null) {
                double d0 = this.target.field_70165_t - this.field_70165_t;
                double d1 = this.target.field_70163_u + (double)this.target.func_70047_e() - (double)1.1f - this.field_70163_u;
                double d2 = this.target.field_70161_v - this.field_70161_v;
                float speed = 0.24f;
                this.func_70186_c(d0, d1, d2, speed, 0.0f);
            } else if (ConfigHandler.canRocketsHome && this.target == null) {
                this.func_70106_y();
            }
        }
        for (int i = 0; i <= 20; ++i) {
            Random random = new Random();
            this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + random.nextGaussian() / 10.0, this.field_70163_u + random.nextGaussian() / 10.0, this.field_70161_v + random.nextGaussian() / 10.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        if (!this.func_130014_f_().field_72995_K) {
            float strength = ConfigHandler.canRocketsDestroyBlocks ? 2.3f : 0.1f;
            this.func_130014_f_().func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true);
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0);
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
            for (Entity mob : targets) {
                int damage = ConfigHandler.getRocketTurretSettings().getDamage();
                if (this.isAmped && mob instanceof EntityLivingBase) {
                    EntityLivingBase elb = (EntityLivingBase)mob;
                    damage = (int)((float)damage + (float)((int)elb.func_110143_aJ()) * (0.08f * (float)this.amp_level));
                }
                if (mob instanceof EntityPlayer && this.canDamagePlayer((EntityPlayer)mob)) {
                    mob.func_70097_a((DamageSource)new NormalDamageSource("rocket"), (float)damage);
                    mob.field_70172_ad = 0;
                }
                if (ConfigHandler.isCanRocketsHurtEnderDragon() && mob instanceof EntityDragon) {
                    ((EntityDragon)mob).func_70606_j(((EntityDragon)mob).func_110143_aJ() - (float)damage);
                    mob.field_70172_ad = 0;
                    continue;
                }
                mob.func_70097_a((DamageSource)new NormalDamageSource("rocket"), (float)damage);
                mob.field_70172_ad = 0;
            }
        }
        this.func_70106_y();
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (!(this.func_130014_f_().field_72995_K || entity instanceof EntityPlayer && !this.canDamagePlayer((EntityPlayer)entity))) {
            float strength = ConfigHandler.canRocketsDestroyBlocks ? 2.3f : 0.1f;
            this.func_130014_f_().func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true);
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0);
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase mob : targets) {
                int damage = ConfigHandler.getRocketTurretSettings().getDamage();
                if (this.isAmped) {
                    EntityLivingBase elb = mob;
                    damage = (int)((float)damage + (float)((int)elb.func_110143_aJ()) * (0.08f * (float)this.amp_level));
                }
                if (mob instanceof EntityPlayer && this.canDamagePlayer((EntityPlayer)mob)) {
                    mob.func_70097_a((DamageSource)new NormalDamageSource("rocket"), (float)damage);
                    mob.field_70172_ad = 0;
                }
                if (ConfigHandler.isCanRocketsHurtEnderDragon() && mob instanceof EntityDragon) {
                    ((EntityDragon)mob).func_70606_j(((EntityDragon)mob).func_110143_aJ() - (float)damage);
                    mob.field_70172_ad = 0;
                } else {
                    mob.func_70097_a((DamageSource)new NormalDamageSource("rocket"), (float)damage);
                    mob.field_70172_ad = 0;
                }
                this.setMobDropLoot((Entity)mob);
            }
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
    }
}

