/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.RandomUtil;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class LaserProjectile
extends TurretProjectile {
    public int arrowShake;

    public LaserProjectile(World par1World) {
        super(par1World);
        this.gravity = 0.0f;
    }

    public LaserProjectile(World par1World, TurretBase turretBase) {
        super(par1World, turretBase);
        this.gravity = 0.0f;
    }

    public void func_70100_b_(EntityPlayer entityPlayer) {
        if (!ConfigHandler.turretDamageTrustedPlayers && this.turretBase.getTrustedPlayer(entityPlayer.func_110124_au()) == null && !PlayerUtil.getPlayerUIDUnstable((String)this.turretBase.getOwner()).equals(entityPlayer.func_110124_au())) {
            this.func_70106_y();
            this.gravity = 0.0f;
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        this.func_70106_y();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onHitEntity(Entity entity) {
        if (entity == null || this.func_130014_f_().field_72995_K) return;
        int damage = ConfigHandler.getLaserTurretSettings().getDamage();
        if (this.isAmped && entity instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)entity;
            damage = (int)((float)damage + (float)((int)elb.func_110143_aJ()) * (0.06f * (float)this.amp_level));
        }
        if (entity instanceof EntityPlayer) {
            if (!this.canDamagePlayer((EntityPlayer)entity)) return;
            entity.func_70015_d(2);
            entity.func_70097_a((DamageSource)new NormalDamageSource("laser"), (float)damage);
            entity.field_70172_ad = 0;
        } else {
            entity.func_70015_d(2);
            entity.func_70097_a((DamageSource)new NormalDamageSource("laser"), (float)damage);
            entity.field_70172_ad = 0;
            this.setMobDropLoot(entity);
        }
        this.func_70106_y();
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
        Random random = RandomUtil.random;
        this.func_130014_f_().func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), ModSounds.laserHitSound, SoundCategory.AMBIENT, ConfigHandler.getTurretSoundVolume(), random.nextFloat() + 0.5f);
    }
}

