/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.ArmorBypassDamageSource;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class GrenadeProjectile
extends TurretProjectile {
    public GrenadeProjectile(World par1World) {
        super(par1World);
        this.gravity = 0.03f;
    }

    public GrenadeProjectile(World world, ItemStack ammo, TurretBase turretBase) {
        super(world, ammo, turretBase);
        this.gravity = 0.03f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= 40) {
            if (!this.func_130014_f_().field_72995_K) {
                float strength = ConfigHandler.canGrenadesDestroyBlocks ? 1.4f : 0.1f;
                this.func_130014_f_().func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true);
                AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 3.0, this.field_70161_v + 3.0);
                List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
                for (EntityLivingBase mob : targets) {
                    int damage = ConfigHandler.getGrenadeTurretSettings().getDamage();
                    if (this.isAmped) {
                        EntityLivingBase elb = mob;
                        damage = (int)((float)damage + (float)((int)elb.func_110143_aJ()) * (0.08f * (float)this.amp_level));
                    }
                    this.setMobDropLoot((Entity)mob);
                    if (mob instanceof EntityPlayer) {
                        if (!this.canDamagePlayer((EntityPlayer)mob)) continue;
                        mob.func_70097_a((DamageSource)new NormalDamageSource("grenade"), (float)damage * 0.9f);
                        mob.func_70097_a((DamageSource)new ArmorBypassDamageSource("grenade"), (float)damage * 0.1f);
                        mob.field_70172_ad = 0;
                        continue;
                    }
                    mob.func_70097_a((DamageSource)new NormalDamageSource("grenade"), (float)damage * 0.9f);
                    mob.func_70097_a((DamageSource)new ArmorBypassDamageSource("grenade"), (float)damage * 0.1f);
                    mob.field_70172_ad = 0;
                }
                this.func_70106_y();
            }
            for (int i = 0; i <= 20; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 1.0, 1.0, new int[0]);
            }
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (!(entity instanceof EntityPlayer) || this.canDamagePlayer((EntityPlayer)entity)) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
    }
}

