/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import omtteam.omlib.util.compat.WorldTools;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class DisposableTurretProjectile
extends TurretProjectile {
    private EntityItem itemBound;
    private boolean spawned = false;

    public DisposableTurretProjectile(World p_i1776_1_) {
        super(p_i1776_1_);
        this.gravity = 0.03f;
    }

    public DisposableTurretProjectile(World par1World, ItemStack ammo, TurretBase turretBase) {
        super(par1World, ammo, turretBase);
        this.gravity = 0.03f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.spawned && !this.func_130014_f_().field_72995_K) {
            this.itemBound = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u - (double)0.2f, this.field_70161_v, this.ammo);
            this.itemBound.field_70159_w = this.field_70159_w;
            this.itemBound.field_70181_x = this.field_70181_x + (double)this.gravity;
            this.itemBound.field_70179_y = this.field_70179_y;
            this.itemBound.func_174867_a(10000);
            WorldTools.spawnEntity((World)this.func_130014_f_(), (Entity)this.itemBound);
            this.spawned = true;
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        if (this.itemBound != null) {
            this.itemBound.func_70106_y();
        }
        this.func_70106_y();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onHitEntity(Entity entity) {
        if (entity == null || this.func_130014_f_().field_72995_K) return;
        int damage = ConfigHandler.getDisposableTurretSettings().getDamage();
        if (this.isAmped && entity instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)entity;
            damage = (int)((float)damage + (float)((int)elb.func_110143_aJ()) * (0.05f * (float)this.amp_level));
        }
        if (entity instanceof EntityPlayer) {
            if (!this.canDamagePlayer((EntityPlayer)entity)) return;
            entity.func_70097_a((DamageSource)new NormalDamageSource("disposable"), (float)damage);
            entity.field_70172_ad = 0;
        } else {
            entity.func_70097_a((DamageSource)new NormalDamageSource("disposable"), (float)damage);
            entity.field_70172_ad = 0;
        }
        this.setMobDropLoot(entity);
        if (this.itemBound != null) {
            this.itemBound.func_70106_y();
        }
        this.func_70106_y();
    }

    public EntityItem getItemBound() {
        return this.itemBound;
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
    }
}

