/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class BlazingClayProjectile
extends TurretProjectile {
    public BlazingClayProjectile(World world) {
        super(world);
        this.gravity = 0.0f;
    }

    public BlazingClayProjectile(World world, ItemStack ammo, TurretBase turretBase) {
        super(world, ammo, turretBase);
        this.gravity = 0.0f;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        if (!this.func_130014_f_().field_72995_K) {
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0);
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
            int damage = ConfigHandler.getIncendiaryTurretSettings().getDamage();
            for (Entity mob : targets) {
                if (mob instanceof EntityPlayer) {
                    if (!this.canDamagePlayer((EntityPlayer)mob)) continue;
                    mob.func_70097_a((DamageSource)new NormalDamageSource("bullet"), (float)damage);
                    mob.field_70172_ad = 0;
                    mob.func_70015_d(5);
                    this.playSound();
                    continue;
                }
                mob.func_70097_a((DamageSource)new NormalDamageSource("bullet"), (float)damage);
                mob.field_70172_ad = 0;
                mob.func_70015_d(5);
                this.playSound();
            }
            this.func_70106_y();
        }
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (!(this.func_130014_f_().field_72995_K || entity instanceof EntityPlayer && !this.canDamagePlayer((EntityPlayer)entity))) {
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0);
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, axis);
            int damage = ConfigHandler.getIncendiaryTurretSettings().getDamage();
            if (this.isAmped && entity instanceof EntityLivingBase) {
                EntityLivingBase elb = (EntityLivingBase)entity;
                damage = (int)((float)damage + (float)((int)elb.func_110143_aJ()) * (0.05f * (float)this.amp_level));
            }
            for (EntityLivingBase mob : targets) {
                this.setMobDropLoot((Entity)mob);
                if (mob instanceof EntityPlayer) {
                    if (this.canDamagePlayer((EntityPlayer)mob)) {
                        mob.func_70097_a((DamageSource)new NormalDamageSource("bullet"), (float)damage);
                        mob.field_70172_ad = 0;
                        mob.func_70015_d(5);
                    }
                } else {
                    mob.func_70097_a((DamageSource)new NormalDamageSource("bullet"), (float)damage);
                    mob.field_70172_ad = 0;
                    mob.func_70015_d(5);
                }
                this.setMobDropLoot(entity);
            }
            this.func_70106_y();
        }
    }

    @ParametersAreNonnullByDefault
    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.field_70163_u += 12.0;
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public void playSound() {
    }
}

