/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import omtteam.omlib.client.gui.BlockingAbstractGuiContainer;
import omtteam.omlib.client.gui.IHasTooltips;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.DebugHandler;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.omlib.util.WorldUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.handler.NetworkingHandler;
import omtteam.openmodularturrets.network.messages.MessageAdjustMaxRange;
import omtteam.openmodularturrets.network.messages.MessageDropBase;
import omtteam.openmodularturrets.network.messages.MessageDropTurrets;
import omtteam.openmodularturrets.network.messages.MessageSetBaseTargetingType;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.TurretHeadUtil;

class TurretBaseAbstractGui
extends BlockingAbstractGuiContainer
implements IHasTooltips {
    private int mouseX;
    private int mouseY;
    private final EntityPlayer player;
    final TurretBase base;

    TurretBaseAbstractGui(InventoryPlayer inventoryPlayer, TurretBase tileEntity, Container container) {
        super(container);
        this.base = tileEntity;
        this.player = inventoryPlayer.field_70458_d;
        DebugHandler.getInstance().setPlayer(this.player);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        TrustedPlayer trustedPlayer = PlayerUtil.getTrustedPlayer((EntityPlayer)this.player, (TileEntityMachine)this.base);
        this.field_146292_n.add(new GuiButton(1, x + 120, y + 15, 20, 20, "+"));
        this.field_146292_n.add(new GuiButton(2, x + 120, y + 50, 20, 20, "-"));
        if (PlayerUtil.isPlayerOwner((EntityPlayer)this.player, (TileEntityOwnedBlock)this.base)) {
            this.field_146292_n.add(new GuiButton(3, x + 180, y, 80, 20, "Drop Turrets"));
            this.field_146292_n.add(new GuiButton(4, x + 180, y + 25, 80, 20, "Drop Base"));
            this.field_146292_n.add(new GuiButton(5, x + 180, y + 50, 80, 20, "Configure"));
            this.field_146292_n.add(new GuiButton(6, x + 180, y + 75, 80, 20, this.base.isMultiTargeting() ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:multi") : GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:single")));
        } else if (trustedPlayer != null) {
            if (trustedPlayer.admin) {
                this.field_146292_n.add(new GuiButton(3, x + 180, y, 80, 20, "Drop Turrets"));
                this.field_146292_n.add(new GuiButton(4, x + 180, y + 25, 80, 20, "Drop Base"));
            }
            if (trustedPlayer.canChangeTargeting || trustedPlayer.admin) {
                this.field_146292_n.add(new GuiButton(5, x + 180, y + 50, 80, 20, "Configure"));
                this.field_146292_n.add(new GuiButton(6, x + 180, y + 75, 80, 20, this.base.isMultiTargeting() ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:multi") : GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:single")));
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.mouseX = par1;
        this.mouseY = par2;
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 1) {
            this.base.setCurrentMaxRange(this.base.getCurrentMaxRange() + 1);
            this.sendChangeToServer();
        }
        if (guibutton.field_146127_k == 2) {
            this.base.setCurrentMaxRange(this.base.getCurrentMaxRange() - 1);
            this.sendChangeToServer();
        }
        if (guibutton.field_146127_k == 3) {
            this.sendDropTurretsToServer();
        }
        if (guibutton.field_146127_k == 4) {
            this.sendDropBaseToServer();
        }
        if (guibutton.field_146127_k == 5) {
            this.player.openGui((Object)OpenModularTurrets.instance, 6, this.player.func_130014_f_(), this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        }
        if (guibutton.field_146127_k == 6) {
            this.sendSetBaseTargetingToServer();
            for (Object button : this.field_146292_n) {
                if (((GuiButton)button).field_146127_k != 6) continue;
                this.base.setMultiTargeting(!this.base.isMultiTargeting());
                ((GuiButton)button).field_146126_j = this.base.isMultiTargeting() ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:multi") : GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:single");
            }
        }
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
    }

    protected void func_146979_b(int param1, int param2) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(this.base.getTier() > 1 ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:addons") : "", 71, 6, 0);
        fontRenderer.func_78276_b(this.base.getTier() > 1 ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:upgrades") : "", 71, 39, 0);
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:ammo"), 8, 6, 0);
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:inventory"), 8, this.field_147000_g - 97 + 4, 0);
        fontRenderer.func_175063_a("" + this.base.getCurrentMaxRange(), String.valueOf(this.base.getCurrentMaxRange()).length() == 1 ? 127.0f : 124.0f, 39.0f, this.base.getCurrentMaxRange() == this.getBaseUpperBoundRange() ? 0xFF3232 : 40000);
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:range"), 116, 6, 0);
        ArrayList<String> targetInfo = new ArrayList<String>();
        targetInfo.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:owner") + ": \u00a7f" + this.base.getOwnerName());
        boolean isCurrentlyOn = this.base.isActive();
        targetInfo.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:active") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)isCurrentlyOn));
        targetInfo.add("");
        if (this.base.getTrustedPlayers().size() != 0) {
            targetInfo.add("\u00a75" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:trusted_players") + ":");
            for (TrustedPlayer trusted_player : this.base.getTrustedPlayers()) {
                targetInfo.add("\u00a7b" + trusted_player.name);
            }
        } else {
            targetInfo.add("\u00a75" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:trusted_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)false));
        }
        targetInfo.add("");
        targetInfo.add("\u00a77" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:attack_mobs") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksMobs()));
        targetInfo.add("\u00a77" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:attack_neutrals") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksNeutrals()));
        targetInfo.add("\u00a77" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:attack_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksPlayers()));
        this.drawHoveringText(targetInfo, -128, 17, fontRenderer);
        this.drawTooltips();
    }

    public void drawTooltips() {
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        int tooltipToDraw = this.field_146292_n.stream().filter(GuiButton::func_146115_a).mapToInt(s -> s.field_146127_k).sum();
        ArrayList<String> tooltip = new ArrayList<String>();
        switch (tooltipToDraw) {
            case 1: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:plus_range"));
                break;
            }
            case 2: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:minus_range"));
                break;
            }
            case 5: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:configure_base"));
                break;
            }
            case 6: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:multi_targeting"));
            }
        }
        if (this.mouseX > k + 153 && this.mouseX < k + 153 + 14 && this.mouseY > l + 17 && this.mouseY < l + 17 + 51) {
            tooltip.add(this.base.getEnergyLevel(EnumFacing.DOWN) + "/" + this.base.getMaxEnergyLevel(EnumFacing.DOWN) + " RF");
        }
        if (this.base.getTier() > 1 && this.mouseX > k + 71 && this.mouseX < k + 71 + 40 && this.mouseY > l + 6 && this.mouseY < l + 6 + 14) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:addon_slot"));
        }
        if (this.base.getTier() > 1 && this.mouseX > k + 71 && this.mouseX < k + 71 + 40 && this.mouseY > l + 39 && this.mouseY < l + 39 + 14) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:upgrade_slot"));
        }
        if (this.mouseX > k + 10 && this.mouseX < k + 8 + 40 && this.mouseY > l + 6 && this.mouseY < l + 6 + 14) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:ammo_slot"));
        }
        if (this.mouseX > k + 123 && this.mouseX < k + 134 && this.mouseY > l + 35 && this.mouseY < l + 48) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:base_max_range"));
        }
        if (!tooltip.isEmpty()) {
            this.drawHoveringText(tooltip, this.mouseX - k, this.mouseY - l, Minecraft.func_71410_x().field_71466_p);
        }
    }

    private void sendChangeToServer() {
        MessageAdjustMaxRange message = new MessageAdjustMaxRange(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p(), this.base.getCurrentMaxRange());
        NetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendDropTurretsToServer() {
        MessageDropTurrets message = new MessageDropTurrets(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        NetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendDropBaseToServer() {
        MessageDropBase message = new MessageDropBase(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        NetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendSetBaseTargetingToServer() {
        MessageSetBaseTargetingType message = new MessageSetBaseTargetingType(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        NetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    public ArrayList<Rectangle> getBlockingAreas() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        Rectangle rectangleGUI = new Rectangle(0, 0, 0, 0);
        if (this.player.func_110124_au().toString().equals(this.base.getOwner())) {
            rectangleGUI = new Rectangle((this.field_146294_l - this.field_146999_f) / 2 + 180, (this.field_146295_m - this.field_147000_g) / 2, 80, 95);
        } else if (this.base.getTrustedPlayer(this.player.func_110124_au()) != null) {
            if (this.base.getTrustedPlayer((UUID)this.player.func_110124_au()).admin) {
                rectangleGUI = new Rectangle((this.field_146294_l - this.field_146999_f) / 2 + 180, (this.field_146295_m - this.field_147000_g) / 2, 80, 45);
            }
            if (this.base.getTrustedPlayer((UUID)this.player.func_110124_au()).canChangeTargeting || this.base.getTrustedPlayer((UUID)this.player.func_110124_au()).admin) {
                rectangleGUI = new Rectangle((this.field_146294_l - this.field_146999_f) / 2 + 180, (this.field_146295_m - this.field_147000_g) / 2 + 50, 80, 20);
            }
        }
        list.add(rectangleGUI);
        return list;
    }

    private int getBaseUpperBoundRange() {
        int maxRange = 0;
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.base.func_145831_w(), (BlockPos)this.base.func_174877_v());
        for (TileEntity te : tileEntities) {
            if (te == null || !(te instanceof TurretHead)) continue;
            maxRange = Math.max(((TurretHead)te).getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), maxRange);
        }
        return maxRange;
    }
}

