/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.api.IHasItemBlock;
import omtteam.omlib.blocks.BlockAbstractCamoTileEntity;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.omlib.util.compat.ChatTools;
import omtteam.omlib.util.compat.ItemStackTools;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.items.UsableMetaItem;
import omtteam.openmodularturrets.items.blocks.ItemBlockTurretBase;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class BlockTurretBase
extends BlockAbstractCamoTileEntity
implements IHasItemBlock {
    public static final PropertyInteger TIER = PropertyInteger.func_177719_a((String)"tier", (int)1, (int)5);

    public BlockTurretBase() {
        super(Material.field_151576_e);
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        if (!ConfigHandler.turretBreakable) {
            this.func_149722_s();
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(1)));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("turret_base");
        this.setRegistryName("openmodularturrets", "turret_base");
    }

    public ItemBlock getItemBlock(Block block) {
        return new ItemBlockTurretBase(block);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)TIER) - 1) {
            case 0: {
                int MaxCharge = ConfigHandler.getBaseTierOneMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierOneMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 1, state);
            }
            case 1: {
                int MaxCharge = ConfigHandler.getBaseTierTwoMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierTwoMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 2, state);
            }
            case 2: {
                int MaxCharge = ConfigHandler.getBaseTierThreeMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierThreeMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 3, state);
            }
            case 3: {
                int MaxCharge = ConfigHandler.getBaseTierFourMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierFourMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 4, state);
            }
            case 4: {
                int MaxCharge = ConfigHandler.getBaseTierFiveMaxCharge();
                int MaxIO = ConfigHandler.getBaseTierFiveMaxIo();
                return new TurretBase(MaxCharge, MaxIO, 5, state);
            }
        }
        return new TurretBase(1, 1, 1, state);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(meta + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TIER}, new IUnlistedProperty[]{RENDERBLOCKSTATE});
    }

    protected boolean clOnBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack heldItem = player.func_184614_ca();
            TurretBase base = (TurretBase)world.func_175625_s(pos);
            if (player.func_70093_af() && ConfigHandler.isAllowBaseCamo() && heldItem == ItemStackTools.getEmptyStack() && base != null) {
                if (player.func_110124_au().toString().equals(base.getOwner())) {
                    base.setCamoState(state);
                    world.func_184138_a(pos, state, state, 3);
                } else {
                    ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"status.ownership")));
                }
            }
            Block heldItemBlock = null;
            if (heldItem != ItemStackTools.getEmptyStack()) {
                heldItemBlock = Block.func_149634_a((Item)heldItem.func_77973_b());
            }
            if (!player.func_70093_af() && ConfigHandler.isAllowBaseCamo() && heldItem != ItemStackTools.getEmptyStack() && heldItem.func_77973_b() instanceof ItemBlock && heldItemBlock.func_149721_r(heldItemBlock.func_176203_a(heldItem.func_77960_j())) && Block.func_149634_a((Item)heldItem.func_77973_b()).func_149662_c(heldItemBlock.func_176203_a(heldItem.func_77960_j())) && !(Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof BlockTurretBase)) {
                if (base != null) {
                    if (player.func_110124_au().toString().equals(base.getOwner())) {
                        base.setCamoState(heldItemBlock.func_176203_a(heldItem.func_77952_i()));
                        world.func_184138_a(pos, state, state, 3);
                    } else {
                        ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"status.ownership")));
                    }
                }
            } else if (player.func_70093_af() && base != null && player.func_184614_ca() != ItemStackTools.getEmptyStack() && player.func_184614_ca().func_77973_b() instanceof UsableMetaItem && player.func_184614_ca().func_77952_i() == 2) {
                ((UsableMetaItem)player.func_184614_ca().func_77973_b()).setDataStored(player.func_184614_ca(), base.writeMemoryCardNBT());
            } else if (!player.func_70093_af() && base != null && player.func_184614_ca() != ItemStackTools.getEmptyStack() && player.func_184614_ca().func_77973_b() instanceof UsableMetaItem && player.func_184614_ca().func_77952_i() == 2 && ((UsableMetaItem)player.func_184614_ca().func_77973_b()).hasDataStored(player.func_184614_ca())) {
                base.readMemoryCardNBT(((UsableMetaItem)player.func_184614_ca().func_77973_b()).getDataStored(player.func_184614_ca()));
            } else if (!player.func_70093_af() && base != null) {
                TrustedPlayer trustedPlayer = PlayerUtil.getTrustedPlayer((EntityPlayer)player, (TileEntityMachine)base);
                if (trustedPlayer != null && trustedPlayer.canOpenGUI) {
                    world.func_184138_a(pos, state, state, 6);
                    player.openGui((Object)OpenModularTurrets.instance, base.getTier(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                if (PlayerUtil.isPlayerOwner((EntityPlayer)player, (TileEntityOwnedBlock)base)) {
                    world.func_184138_a(pos, state, state, 6);
                    player.openGui((Object)OpenModularTurrets.instance, base.getTier(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                } else {
                    ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"status.ownership")));
                }
            }
        }
        return true;
    }

    protected void clOnNeighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.field_72995_K) {
            TurretBase base = (TurretBase)worldIn.func_175625_s(pos);
            if (base != null && worldIn.func_175687_A(pos) > 0) {
                base.setRedstone(true);
            } else if (base != null && worldIn.func_175687_A(pos) == 0) {
                base.setRedstone(false);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TurretBase) {
            EntityPlayerMP player = (EntityPlayerMP)placer;
            TurretBase base = (TurretBase)worldIn.func_175625_s(pos);
            if (base == null) {
                return;
            }
            base.setCamoState(state);
            base.setOwner(player.func_110124_au().toString());
            if (worldIn.func_175687_A(pos) > 0) {
                base.setRedstone(true);
            } else if (worldIn.func_175687_A(pos) == 0) {
                base.setRedstone(false);
            }
            base.func_70296_d();
            switch ((Integer)state.func_177229_b((IProperty)TIER)) {
                case 1: {
                    this.func_149752_b(ConfigHandler.getBaseTierOneBlastResistance());
                    this.func_149711_c(ConfigHandler.getBaseTierOneHardness());
                    break;
                }
                case 2: {
                    this.func_149752_b(ConfigHandler.getBaseTierTwoBlastResistance());
                    this.func_149711_c(ConfigHandler.getBaseTierTwoHardness());
                    break;
                }
                case 3: {
                    this.func_149752_b(ConfigHandler.getBaseTierThreeBlastResistance());
                    this.func_149711_c(ConfigHandler.getBaseTierThreeHardness());
                    break;
                }
                case 4: {
                    this.func_149752_b(ConfigHandler.getBaseTierFourBlastResistance());
                    this.func_149711_c(ConfigHandler.getBaseTierFourHardness());
                    break;
                }
                case 5: {
                    this.func_149752_b(ConfigHandler.getBaseTierFiveBlastResistance());
                    this.func_149711_c(ConfigHandler.getBaseTierFiveHardness());
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.dropItems(worldIn, pos);
            worldIn.func_175713_t(pos);
        }
    }

    @ParametersAreNonnullByDefault
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        switch ((Integer)blockState.func_177229_b((IProperty)TIER)) {
            case 1: {
                return ConfigHandler.getBaseTierOneHardness();
            }
            case 2: {
                return ConfigHandler.getBaseTierTwoHardness();
            }
            case 3: {
                return ConfigHandler.getBaseTierThreeHardness();
            }
            case 4: {
                return ConfigHandler.getBaseTierFourHardness();
            }
            case 5: {
                return ConfigHandler.getBaseTierFiveHardness();
            }
        }
        return 10.0f;
    }

    @ParametersAreNonnullByDefault
    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        switch ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)TIER)) {
            case 1: {
                return ConfigHandler.getBaseTierOneBlastResistance();
            }
            case 2: {
                return ConfigHandler.getBaseTierTwoBlastResistance();
            }
            case 3: {
                return ConfigHandler.getBaseTierThreeBlastResistance();
            }
            case 4: {
                return ConfigHandler.getBaseTierFourBlastResistance();
            }
            case 5: {
                return ConfigHandler.getBaseTierFiveBlastResistance();
            }
        }
        return 10.0f;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(0, new ItemStack(ModBlocks.turretBase, 1, this.func_176201_c(state)));
        return drops;
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.turretBase, 1, (Integer)state.func_177229_b((IProperty)TIER) - 1);
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void clGetSubBlocks(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i < 5; ++i) {
            subItems.add(new ItemStack(ModBlocks.turretBase, 1, i));
        }
    }
}

