/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.api.IHasItemBlock;
import omtteam.omlib.blocks.BlockAbstractTileEntity;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;
import omtteam.omlib.util.WorldUtil;
import omtteam.omlib.util.compat.ChatTools;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.handler.ConfigHandler;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.items.blocks.ItemBlockExpander;
import omtteam.openmodularturrets.tileentity.Expander;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.util.ITurretBaseAddonBlock;

public class BlockExpander
extends BlockAbstractTileEntity
implements IHasItemBlock,
ITurretBaseAddonBlock {
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)9);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockExpander() {
        super(Material.field_151592_s);
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        if (!ConfigHandler.turretBreakable) {
            this.func_149722_s();
        }
        this.func_149752_b(3.0f);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(0)));
        this.func_149663_c("expander");
        this.setRegistryName("openmodularturrets", "expander");
    }

    public ItemBlock getItemBlock(Block block) {
        return new ItemBlockExpander(block);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META, FACING});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Expander te = (Expander)worldIn.func_175625_s(pos);
        if (te != null) {
            return state.func_177226_a((IProperty)FACING, (Comparable)te.getOrientation());
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World world, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)META) < 5) {
            return new Expander((Integer)state.func_177229_b((IProperty)META), false);
        }
        return new Expander((Integer)state.func_177229_b((IProperty)META), true);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState blockState = this.func_176221_a(state, source, pos);
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return BlockExpander.getBoundingBoxFromFacing(facing);
    }

    @Override
    public AxisAlignedBB getBoundingBoxFromState(IBlockState blockState, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return BlockExpander.getBoundingBoxFromFacing(facing).func_186670_a(pos);
    }

    public static AxisAlignedBB getBoundingBoxFromFacing(EnumFacing facing) {
        AxisAlignedBB alignedBB = MathUtil.rotateAABB((AxisAlignedBB)new AxisAlignedBB(-0.375, -0.375, -0.1875, 0.375, 0.375, 0.1875), (EnumFacing)facing.func_176734_d());
        double[] offset = new double[]{0.5 + (double)facing.func_82601_c() * 0.325, 0.5 + (double)facing.func_96559_d() * 0.325, 0.5 + (double)facing.func_82599_e() * 0.325};
        return alignedBB.func_72317_d(offset[0], offset[1], offset[2]);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean clOnBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand.equals((Object)EnumHand.OFF_HAND)) {
            return true;
        }
        Expander expander = (Expander)worldIn.func_175625_s(pos);
        if (expander == null) {
            return true;
        }
        TurretBase base = expander.getBase();
        if (base == null) {
            worldIn.func_175655_b(pos, true);
            return true;
        }
        TrustedPlayer trustedPlayer = PlayerUtil.getTrustedPlayer((EntityPlayer)playerIn, (TileEntityMachine)base);
        if (trustedPlayer != null && base.getTrustedPlayer((UUID)playerIn.func_110124_au()).canOpenGUI && (Integer)state.func_177229_b((IProperty)META) < 5) {
            playerIn.openGui((Object)OpenModularTurrets.instance, 7, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (PlayerUtil.isPlayerOwner((EntityPlayer)playerIn, (TileEntityOwnedBlock)base)) {
            if (playerIn.func_70093_af() && playerIn.func_184614_ca() == null) {
                worldIn.func_175655_b(pos, true);
                return true;
            } else {
                if ((Integer)state.func_177229_b((IProperty)META) >= 5) return true;
                playerIn.openGui((Object)OpenModularTurrets.instance, 7, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        } else {
            ChatTools.addChatMessage((ICommandSender)playerIn, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize((String)"status.ownership")));
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)worldIn, (BlockPos)pos)) {
            if (!(tileEntity instanceof TurretBase)) continue;
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.dropItems(worldIn, pos);
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Expander expander = (Expander)worldIn.func_175625_s(pos);
        if (expander != null) {
            expander.setOwnerName(expander.getBase().getOwnerName());
            expander.setOwner(expander.getBase().getOwner());
            expander.setSide();
        }
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void clGetSubBlocks(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i < 10; ++i) {
            subItems.add(new ItemStack(ModBlocks.expander, 1, i));
        }
    }
}

