/*
 * Decompiled with CFR 0.152.
 */
package wtf.gravity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.config.GameplayConfig;
import wtf.gravity.EntityWTFFallingBlock;
import wtf.gravity.EntityWTFSlidingBlock;
import wtf.init.BlockSets;

public class GravityMethods {
    private static final Random random = new Random();
    private static int grassHash = Blocks.field_150349_c.hashCode();
    private static int airHash = Blocks.field_150350_a.hashCode();

    public static void checkPos(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.hashCode() == grassHash) {
            block = Blocks.field_150346_d;
        } else if (!BlockSets.fallingBlocks.containsKey(block)) {
            return;
        }
        if (BlockSets.nonSolidBlockSet.contains(world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            int blockhash = block.hashCode();
            double fallchance = 1.0;
            for (int loop = 1; loop < 6 && blockhash == world.func_180495_p(pos.func_177981_b(loop)).func_177230_c().hashCode(); ++loop) {
                fallchance *= (double)(1.0f - ((Float)BlockSets.fallingBlocks.get(block)).floatValue());
            }
            if ((double)random.nextFloat() < fallchance) {
                GravityMethods.dropBlock(world, pos, true);
            }
            return;
        }
        BlockPos downpos = pos.func_177977_b();
        Block downBlock = world.func_180495_p(downpos).func_177230_c();
        if (GameplayConfig.antiNerdPole && BlockSets.fallingBlocks.containsKey(downBlock) && GravityMethods.unstableTowerPos(world, pos.func_177977_b()) && !GravityMethods.fenceNear(world, pos, 1, 2)) {
            int count;
            for (count = 1; count < 5 && GravityMethods.unstableTowerPos(world, pos.func_177979_c(count)); ++count) {
            }
            if (random.nextFloat() * (float)count > ((Float)BlockSets.fallingBlocks.get(downBlock)).floatValue()) {
                EntityWTFSlidingBlock entityfallingblock = new EntityWTFSlidingBlock(world, pos, GravityMethods.getRandomAdj(pos), state);
                entityfallingblock.func_145806_a(GameplayConfig.fallingBlocksDamage);
            }
        }
    }

    public static boolean unstableTowerPos(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177978_c()).func_177230_c().hashCode() == airHash && world.func_180495_p(pos.func_177978_c().func_177974_f()).func_177230_c().hashCode() == airHash && world.func_180495_p(pos.func_177978_c().func_177976_e()).func_177230_c().hashCode() == airHash && world.func_180495_p(pos.func_177968_d()).func_177230_c().hashCode() == airHash && world.func_180495_p(pos.func_177968_d().func_177974_f()).func_177230_c().hashCode() == airHash && world.func_180495_p(pos.func_177968_d().func_177976_e()).func_177230_c().hashCode() == airHash && world.func_180495_p(pos.func_177974_f()).func_177230_c().hashCode() == airHash && world.func_180495_p(pos.func_177976_e()).func_177230_c().hashCode() == airHash && !GravityMethods.fenceNear(world, pos.func_177979_c(2), 1, 0);
    }

    public static boolean dropBlock(World world, BlockPos pos, Boolean checkSupport) {
        if (BlockSets.fallingBlocks.containsKey(world.func_180495_p(pos).func_177230_c())) {
            if (checkSupport.booleanValue() && GravityMethods.fenceNear(world, pos, 1, 1)) {
                return false;
            }
            EntityWTFFallingBlock entityfallingblock = new EntityWTFFallingBlock(world, pos, world.func_180495_p(pos));
            entityfallingblock.func_145806_a(GameplayConfig.fallingBlocksDamage);
            if (world.field_72995_K || world.func_72838_d((Entity)entityfallingblock)) {
                // empty if block
            }
            if (checkSupport.booleanValue()) {
                GravityMethods.checkPos(world, pos.func_177984_a());
            } else {
                GravityMethods.dropBlock(world, pos.func_177984_a(), false);
            }
            return true;
        }
        return false;
    }

    public static boolean fenceNear(World world, BlockPos pos, int radius, int down) {
        for (int xloop = -radius; xloop < radius + 1; ++xloop) {
            for (int yloop = -down; yloop < 1; ++yloop) {
                for (int zloop = -radius; zloop < radius + 1; ++zloop) {
                    if (!(world.func_180495_p(new BlockPos(pos.func_177958_n() + xloop, pos.func_177956_o() + yloop, pos.func_177952_p() + zloop)).func_177230_c() instanceof BlockFence)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static BlockPos getRandomAdj(BlockPos pos) {
        int chance = random.nextInt(4);
        switch (chance) {
            case 0: {
                return pos.func_177978_c();
            }
            case 1: {
                return pos.func_177974_f();
            }
            case 2: {
                return pos.func_177968_d();
            }
            case 3: {
                return pos.func_177976_e();
            }
        }
        return null;
    }
}

