/*
 * Decompiled with CFR 0.152.
 */
package wtf.fracturing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.blocks.BlockDecoAnim;
import wtf.blocks.BlockDecoStatic;
import wtf.config.GameplayConfig;
import wtf.entities.IUtilityEntity;
import wtf.fracturing.FracVec;
import wtf.gravity.GravityMethods;
import wtf.init.BlockSets;

public class EntityStoneCrack
extends Entity
implements IUtilityEntity {
    private int count;
    Random random = new Random();
    private final BlockPos ori;
    ArrayList<FracVec> cracking = new ArrayList();

    public EntityStoneCrack(World worldIn, BlockPos pos) {
        super(worldIn);
        if (pos != null) {
            this.field_70165_t = pos.func_177958_n();
            this.field_70163_u = pos.func_177956_o();
            this.field_70161_v = pos.func_177952_p();
        }
        this.ori = pos;
    }

    public EntityStoneCrack() {
        super(null);
        this.ori = null;
    }

    public void doEvent(World world, BlockPos pos) {
        EntityStoneCrack.crackStone(world, pos);
    }

    public static void crackStone(World world, BlockPos pos) {
        EntityStoneCrack crack = new EntityStoneCrack(world, pos);
        crack.addAllAdj(pos);
        world.func_72838_d((Entity)crack);
    }

    public static void FracOreSmple(World world, BlockPos pos) {
        EntityStoneCrack crack = new EntityStoneCrack(world, pos);
        crack.addAdj(pos);
        world.func_72838_d((Entity)crack);
    }

    public static void FracOre(World world, BlockPos pos, int toolLevel) {
        EntityStoneCrack crack = new EntityStoneCrack(world, pos);
        crack.crackOre(world, pos, toolLevel);
        world.func_72838_d((Entity)crack);
    }

    public static void cracHammer(World world, BlockPos pos, int toolLevel) {
        EntityStoneCrack crack = new EntityStoneCrack(world, pos);
        crack.crackHammer(world, pos, toolLevel);
        world.func_72838_d((Entity)crack);
    }

    public void crackOre(World world, BlockPos pos, int toolLevel) {
        int blockLevel = world.func_180495_p(pos).func_177230_c().getHarvestLevel(world.func_180495_p(pos));
        EntityStoneCrack crack = new EntityStoneCrack(world, pos);
        int numLoop = (toolLevel + 1) * 4;
        int maxDist = 1 + blockLevel;
        for (int loop = 0; loop < numLoop; ++loop) {
            int blockToFrac = MathHelper.func_76125_a((int)(1 + this.random.nextInt(blockLevel + 1)), (int)1, (int)maxDist);
            if (this.random.nextBoolean()) {
                this.cracking.add(new FracVec(pos, blockToFrac, maxDist, this.random));
                continue;
            }
            for (int vecLoop = 0; vecLoop < blockToFrac; ++vecLoop) {
                this.cracking.add(new FracVec(pos, 1, maxDist, this.random));
            }
        }
        world.func_72838_d((Entity)crack);
    }

    public void crackHammer(World world, BlockPos pos, int toolLevel) {
        EntityStoneCrack crack = new EntityStoneCrack(world, pos);
        Random posRandom = new Random(pos.hashCode());
        int numLoop = toolLevel + 1;
        for (int loop = 0; loop < numLoop; ++loop) {
            int blockToFrac = 1 + this.random.nextInt(toolLevel + 1);
            int maxDist = 1 + toolLevel;
            this.cracking.add(new FracVec(pos, blockToFrac, maxDist, posRandom));
        }
        world.func_72838_d((Entity)crack);
    }

    private void addAllAdj(BlockPos pos) {
        ArrayList<FracVec> list = new ArrayList<FracVec>();
        for (int xloop = -1; xloop < 2; ++xloop) {
            for (int yloop = -1; yloop < 2; ++yloop) {
                for (int zloop = -1; zloop < 2; ++zloop) {
                    FracVec vec = new FracVec(pos, 1, 1, xloop, yloop, zloop);
                    list.add(vec);
                }
            }
        }
        Collections.shuffle(list);
        this.cracking.addAll(list);
    }

    private void addAdj(BlockPos pos) {
        ArrayList<FracVec> list = new ArrayList<FracVec>();
        list.add(new FracVec(pos, 1, 1, 1.0, 0.0, 0.0));
        list.add(new FracVec(pos, 1, 1, -1.0, 0.0, 0.0));
        list.add(new FracVec(pos, 1, 1, 0.0, 1.0, 0.0));
        list.add(new FracVec(pos, 1, 1, 0.0, -1.0, 0.0));
        list.add(new FracVec(pos, 1, 1, 0.0, 0.0, 1.0));
        list.add(new FracVec(pos, 1, 1, 0.0, 0.0, -1.0));
        Collections.shuffle(list);
        this.cracking.addAll(list);
    }

    public void func_70071_h_() {
        if (this.count < this.cracking.size()) {
            int random;
            for (int loop = random = (this.field_70170_p.field_73012_v.nextInt(3) + 1) * this.cracking.size() / 27; loop > -1 && this.count < this.cracking.size(); --loop) {
                FracVec vec = this.cracking.get(this.count);
                this.doVec(vec);
                ++this.count;
            }
        } else {
            this.func_70106_y();
        }
    }

    private void doVec(FracVec vec) {
        for (int fracloop = 0; fracloop <= vec.blocksToFrac; ++fracloop) {
            for (int dist = 1; dist <= vec.maxDist; ++dist) {
                BlockPos pos = vec.getPos(dist);
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                IBlockState cobble = BlockSets.getTransformedState((IBlockState)state, (BlockSets.Modifier)BlockSets.Modifier.COBBLE);
                if (state.func_177230_c() instanceof BlockDecoAnim && state.func_177229_b(BlockDecoAnim.TYPE) == BlockDecoAnim.ANIMTYPE.LAVA_CRUST) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
                    continue;
                }
                if (state.func_177230_c() instanceof BlockDecoStatic && state.func_177229_b(BlockDecoStatic.TYPE) == BlockDecoStatic.DecoType.CRACKED) {
                    BlockDecoStatic block = (BlockDecoStatic)state.func_177230_c();
                    cobble = BlockSets.getTransformedState((IBlockState)block.parentBackground, (BlockSets.Modifier)BlockSets.Modifier.COBBLE);
                    if (cobble == null) continue;
                    this.field_70170_p.func_175656_a(pos, cobble);
                    if (GameplayConfig.gravity) {
                        GravityMethods.dropBlock(this.field_70170_p, pos, true);
                    }
                    this.addAllAdj(pos);
                    continue;
                }
                if (cobble != null) {
                    this.field_70170_p.func_175656_a(pos, cobble);
                    if (!GameplayConfig.gravity) continue;
                    GravityMethods.dropBlock(this.field_70170_p, pos, true);
                    continue;
                }
                if (BlockSets.isFractured((IBlockState)state)) continue;
                return;
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

