/*
 * Decompiled with CFR 0.152.
 */
package wtf.explosions;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import wtf.config.GameplayConfig;
import wtf.config.StoneRegEntry;
import wtf.config.WTFStoneRegistry;
import wtf.eventlisteners.ListenerStoneFrac;
import wtf.explosions.CustomExplosion;
import wtf.explosions.ExploderEntity;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.Vec;

public class ExpVec
extends Vec {
    private final World world;
    private double str;
    float attenuation = 0.75f;
    private final boolean flaming;
    private final CustomExplosion explosion;
    int waterHash = Material.field_151586_h.hashCode();
    int lavaHash = Material.field_151587_i.hashCode();
    IBlockState air = Blocks.field_150350_a.func_176223_P();

    public ExpVec(World world, BlockPos pos, double x, double y, double z, double vecStr, CustomExplosion explosion) {
        super(pos, x, y, z);
        this.world = world;
        this.str = vecStr;
        this.explosion = explosion;
        this.flaming = explosion.flaming;
    }

    public boolean increment() {
        if (!this.hasNext()) {
            return false;
        }
        BlockPos pos = this.next();
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        float resistance = block.func_149638_a(this.explosion.sourceEntity);
        int hash = state.func_185904_a().hashCode();
        if (hash == this.waterHash || hash == this.lavaHash) {
            this.world.func_180501_a(pos, this.air, 2);
        } else {
            double atomize;
            float chance;
            if (BlockSets.explosiveBlocks.containsKey(block)) {
                this.world.func_180501_a(pos, this.air, 2);
                ExploderEntity entity = new ExploderEntity(this.world, null, pos, ((Float)BlockSets.explosiveBlocks.get(block)).floatValue());
                this.world.func_72838_d((Entity)entity);
            }
            if ((chance = (float)(((atomize = (double)resistance * GameplayConfig.expLvlAatomize) - this.str) / atomize)) > 1.0f) {
                this.str -= (double)resistance;
                block.func_180652_a(this.world, pos, (Explosion)this.explosion);
                this.world.func_180501_a(pos, this.air, 2);
                this.explosion.spawnExtraParticles(pos, 2.0f, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else if (this.str > (double)resistance * GameplayConfig.expLvlDrop) {
                this.str -= (double)resistance;
                block.func_180652_a(this.world, pos, (Explosion)this.explosion);
                if (block.func_149659_a((Explosion)this.explosion)) {
                    block.func_180653_a(this.world, pos, state, chance, 0);
                } else {
                    block.func_180652_a(this.world, pos, (Explosion)this.explosion);
                }
                if (this.flaming) {
                    this.world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 2);
                } else {
                    this.world.func_180501_a(pos, this.air, 2);
                }
            } else if (GameplayConfig.explosionFractures) {
                this.str -= (double)(resistance / 3.0f);
                StoneRegEntry entry = (StoneRegEntry)WTFStoneRegistry.stoneReg.get(state);
                if (entry != null && entry.fractures) {
                    ListenerStoneFrac.doFrac(this.world, pos, state);
                }
            }
        }
        this.str -= (double)this.attenuation;
        return true;
    }

    public double getStr() {
        return this.str;
    }

    public double strX() {
        return this.str * this.vecX;
    }

    public double strY() {
        return this.str * this.vecY;
    }

    public double strZ() {
        return this.str * this.vecZ;
    }

    public boolean hasNext() {
        return this.str > 0.0;
    }
}

