/*
 * Decompiled with CFR 0.152.
 */
package wtf.explosions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import wtf.config.GameplayConfig;
import wtf.explosions.ExpVec;
import wtf.gravity.GravityMethods;

public class CustomExplosion
extends Explosion {
    private final World world;
    Random random = new Random();
    public Entity sourceEntity;
    boolean field_82755_b = false;
    public boolean flaming = false;
    public HashMap<BlockPos, Block> fluids = new HashMap();
    int counterMod;
    HashSet<ExpVec> vecList = new HashSet();
    float motionFactor = 2.0f;
    protected Map<Entity, Vec3d> affectedPlayers = new HashMap<Entity, Vec3d>();
    int airHash = Blocks.field_150350_a.hashCode();

    public CustomExplosion(Entity entity, World world, Vec3d vec3d, float str) {
        super(world, entity, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, str, false, false);
        this.world = world;
        BlockPos origin = new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        this.sourceEntity = entity;
        this.counterMod = 0;
        this.populateVectorList(new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), str);
        this.doExplosionB(origin, str);
    }

    public CustomExplosion(Entity entity, World world, Vec3d vec3d, float str, boolean fire) {
        super(world, entity, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, str, false, false);
        this.flaming = fire;
        this.field_82755_b = fire;
        this.world = world;
        BlockPos origin = new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        this.sourceEntity = entity;
        this.counterMod = 0;
        this.populateVectorList(new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), str);
        this.doExplosionB(origin, str);
    }

    protected void populateVectorList(BlockPos origin, float baseStr) {
        float xpos = this.getModifier(origin.func_177974_f());
        float xneg = this.getModifier(origin.func_177976_e());
        float ypos = this.getModifier(origin.func_177984_a());
        float yneg = this.sourceEntity instanceof EntityCreeper ? (float)((double)this.getModifier(origin.func_177977_b()) / GameplayConfig.creeperUpConstant) : this.getModifier(origin.func_177977_b());
        float zpos = this.getModifier(origin.func_177978_c());
        float zneg = this.getModifier(origin.func_177968_d());
        float ftotal = xpos + xneg + ypos + yneg + zpos + zneg;
        xpos = this.setModifier(xpos, ftotal) * baseStr;
        xneg = this.setModifier(xneg, ftotal) * baseStr;
        ypos = this.setModifier(ypos, ftotal) * baseStr;
        yneg = this.setModifier(yneg, ftotal) * baseStr;
        zpos = this.setModifier(zpos, ftotal) * baseStr;
        zneg = this.setModifier(zneg, ftotal) * baseStr;
        int xMin = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(-4.0f * xneg)), (int)-12, (int)-4);
        int xMax = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(4.0f * xpos)), (int)4, (int)12);
        int yMin = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(-4.0f * yneg)), (int)-12, (int)-4);
        int yMax = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(4.0f * ypos)), (int)4, (int)12);
        int zMin = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(-4.0f * zneg)), (int)-12, (int)-4);
        int zMax = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(4.0f * zpos)), (int)4, (int)12);
        for (int xloop = xMin; xloop < xMax + 1; ++xloop) {
            for (int yloop = yMin; yloop < yMax + 1; ++yloop) {
                for (int zloop = zMin; zloop < zMax + 1; ++zloop) {
                    float ycomp;
                    float xcomp;
                    if (xloop != xMin && xloop != xMax && yloop != yMin && yloop != yMax && zloop != zMin && zloop != zMax) continue;
                    double vectorLength = Math.sqrt(xloop * xloop + yloop * yloop + zloop * zloop);
                    double incX = (double)xloop / vectorLength;
                    double incY = (double)yloop / vectorLength;
                    double incZ = (double)zloop / vectorLength;
                    float f = xloop == 0 ? 0.0f : (xcomp = xloop > 0 ? xpos : xneg);
                    float f2 = yloop == 0 ? 0.0f : (ycomp = yloop > 0 ? ypos : yneg);
                    float zcomp = zloop == 0 ? 0.0f : (zloop > 0 ? zpos : zneg);
                    double absIncX = Math.abs(incX);
                    double absIncY = Math.abs(incY);
                    double absIncZ = Math.abs(incZ);
                    double total = absIncX + absIncY + absIncZ;
                    double vector = ((double)xcomp * (absIncX / total) + (double)ycomp * (absIncY / total) + (double)zcomp * (absIncZ / total)) * (0.7 + (double)this.random.nextFloat() * 0.6);
                    this.vecList.add(new ExpVec(this.world, origin, incX, incY, incZ, vector, this));
                }
            }
        }
    }

    public void incrementVectorList() {
        Iterator<ExpVec> iterator = this.vecList.iterator();
        while (iterator.hasNext()) {
            ExpVec vec = iterator.next();
            if (vec.increment()) {
                this.func_180343_e().add(vec.pos());
                this.func_180343_e().add(vec.pos().func_177984_a());
                this.func_180343_e().add(vec.pos().func_177977_b());
                this.func_180343_e().add(vec.pos().func_177974_f());
                this.func_180343_e().add(vec.pos().func_177976_e());
                this.func_180343_e().add(vec.pos().func_177978_c());
                this.func_180343_e().add(vec.pos().func_177968_d());
                BlockPos end = vec.pos();
                List list = this.world.func_72839_b(this.sourceEntity, new AxisAlignedBB(end));
                float damage = (float)vec.getStr() * 7.5f;
                if (list.size() <= 0 || !(vec.getStr() > 0.0)) continue;
                for (Entity entity : list) {
                    double d11 = 1.0;
                    if (entity instanceof EntityLivingBase) {
                        d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)damage);
                        if (vec.getStr() > 0.5) {
                            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)(d11 * (double)damage * GameplayConfig.explosionDamageMod));
                        }
                    }
                    entity.func_70024_g(vec.strX() / 10.0 * GameplayConfig.explosionForceMod, vec.strY() / 10.0 * GameplayConfig.explosionForceMod, vec.strZ() / 10.0 * GameplayConfig.explosionForceMod);
                    entity.field_70133_I = true;
                }
                continue;
            }
            iterator.remove();
        }
    }

    public void doExplosionB(BlockPos origin, float baseStr) {
        this.world.func_184148_a((EntityPlayer)null, (double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (baseStr >= 2.0f && this.field_82755_b) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, (double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p(), 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p(), 1.0, 0.0, 0.0, new int[0]);
        }
    }

    public void spawnExtraParticles(BlockPos origin, float baseStr, int i, int j, int k) {
        double d0 = (float)i + this.world.field_73012_v.nextFloat();
        double d1 = (float)j + this.world.field_73012_v.nextFloat();
        double d2 = (float)k + this.world.field_73012_v.nextFloat();
        double d3 = d0 - (double)origin.func_177958_n();
        double d4 = d1 - (double)origin.func_177956_o();
        double d5 = d2 - (double)origin.func_177952_p();
        double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        d3 /= d6;
        d4 /= d6;
        d5 /= d6;
        double d7 = 0.5 / (d6 / (double)baseStr + 0.1);
        this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + (double)origin.func_177958_n() * 1.0) / 2.0, (d1 + (double)origin.func_177956_o() * 1.0) / 2.0, (d2 + (double)origin.func_177952_p() * 1.0) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
        this.world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, d3, d4, d5, new int[0]);
    }

    private float getModifier(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        float mod = MathHelper.func_76129_c((float)MathHelper.func_76129_c((float)(1.0f / (1.0f + state.func_177230_c().func_149638_a(this.sourceEntity) * 5.0f * state.func_185887_b(this.world, pos)))));
        if (mod < 1.0f) {
            ++this.counterMod;
            return mod;
        }
        return 0.95f;
    }

    private float setModifier(float dir, float totalAssigned) {
        float ret = dir / (totalAssigned / 6.0f);
        return ret;
    }

    void update() {
        for (BlockPos pos : this.func_180343_e()) {
            IBlockState iblockstate = this.world.func_180495_p(pos);
            iblockstate.func_189546_a(this.world, pos, iblockstate.func_177230_c());
            if (!GameplayConfig.gravity) continue;
            GravityMethods.checkPos(this.world, pos);
        }
        this.func_180342_d();
    }
}

