/*
 * Decompiled with CFR 0.152.
 */
package wtf.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wtf.Core;

public class RecipeWrapper {
    private final ArrayList<ArrayList<ItemStack>> wrappedRecipe = new ArrayList();
    public final ItemStack output;

    public RecipeWrapper(ShapelessRecipes rawRecipe) {
        for (ItemStack stack : rawRecipe.field_77579_b) {
            this.wrappedRecipe.add(this.getSublist((IRecipe)rawRecipe, stack));
        }
        this.output = rawRecipe.func_77571_b();
    }

    public RecipeWrapper(ShapedRecipes rawRecipe) {
        for (ItemStack stack : rawRecipe.field_77574_d) {
            this.wrappedRecipe.add(this.getSublist((IRecipe)rawRecipe, stack));
        }
        this.output = rawRecipe.func_77571_b();
    }

    public RecipeWrapper(ShapelessOreRecipe rawRecipe) {
        for (Object obj : rawRecipe.getInput()) {
            this.wrappedRecipe.add(this.getSublist((IRecipe)rawRecipe, obj));
        }
        this.output = rawRecipe.func_77571_b();
    }

    public RecipeWrapper(ShapedOreRecipe rawRecipe) {
        int width = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)rawRecipe, (String[])new String[]{"width"});
        int height = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)rawRecipe, (String[])new String[]{"height"});
        int count = 0;
        Object[] ingrediants = rawRecipe.getInput();
        for (int hloop = 0; hloop < 3; ++hloop) {
            for (int vloop = 0; vloop < 3; ++vloop) {
                if (hloop < height && vloop < width && count < ingrediants.length) {
                    this.wrappedRecipe.add(this.getSublist((IRecipe)rawRecipe, ingrediants[count]));
                    ++count;
                    continue;
                }
                this.wrappedRecipe.add(new ArrayList());
            }
        }
        this.output = rawRecipe.func_77571_b();
    }

    public ArrayList<ArrayList<ItemStack>> getIngrediants() {
        return this.wrappedRecipe;
    }

    private ArrayList<ItemStack> getSublist(IRecipe recipe, Object obj) {
        ArrayList<ItemStack> subList = new ArrayList<ItemStack>();
        if (obj instanceof ItemStack) {
            subList = this.parseItemStack(recipe, subList, (ItemStack)obj);
        } else if (obj instanceof List) {
            for (Object subObj : (List)obj) {
                subList = this.parseItemStack(recipe, subList, (ItemStack)subObj);
            }
        } else if (obj != null) {
            Core.coreLog.info("Skipping unrecognised object in a recipe " + obj);
        }
        return subList;
    }

    public ArrayList<ItemStack> parseItemStack(IRecipe recipe, ArrayList<ItemStack> subList, ItemStack stack) {
        block5: {
            try {
                if (stack != null && (stack.func_77952_i() < 0 || stack.func_77952_i() > 15)) {
                    for (int loop = 0; loop < 15; ++loop) {
                        ItemStack newStack = new ItemStack(stack.func_77973_b(), stack.field_77994_a, loop);
                        subList.add(newStack);
                    }
                } else {
                    subList.add(stack);
                }
            }
            catch (NullPointerException e) {
                if (recipe == null) break block5;
                Core.coreLog.info("Ignoring bad itemstack while trying to parse recipe ingrediant for unknown recipe ");
            }
        }
        return subList;
    }
}

