/*
 * Decompiled with CFR 0.152.
 */
package wtf.config;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import wtf.Core;
import wtf.config.AbstractConfig;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.UBC.UBCCompat;

public class GameplayConfig
extends AbstractConfig {
    public static int torchLifespan;
    public static int torchRange;
    public static boolean relightTorchByHand;
    public static boolean replaceTorch;
    public static boolean modifyHammer;
    public static boolean fallingBlocksDamage;
    public static boolean antiNerdPole;
    public static boolean gravity;
    public static boolean customExplosion;
    public static boolean explosionFractures;
    public static double expLvlAatomize;
    public static double expLvlDrop;
    public static double creeperUpConstant;
    public static boolean homescroll;
    public static boolean miningSpeedEnabled;
    public static boolean miningStoneFractures;
    public static boolean miningOreFractures;
    public static int featherDrop;
    public static int stickDrop;
    public static int mobDropsReqPlayer;
    public static double appleCoreConstant;
    public static boolean plantGrowthMod;
    public static boolean wcictable;
    public static boolean removeVanillaTools;
    public static boolean sulfurRecipe;
    public static Configuration config;
    public static boolean waterControl;
    public static boolean childZombie;
    public static double explosionDamageMod;
    public static double explosionForceMod;
    public static boolean fracSimple;

    public static void loadConfig() throws Exception {
        config.load();
        modifyHammer = config.get("Mining", "Modify hammer behaviour", true).getBoolean();
        miningSpeedEnabled = config.get("Mining", "Enable mining speed modification (values are set in the Stone Registry)", true).getBoolean();
        miningStoneFractures = config.get("Mining", "Stone fractures upon mining (individual stones disabled in the stone registry)", true).getBoolean();
        miningOreFractures = config.get("Mining", "Ores fracture adjacent stone upon mining (Individual blocks can be removed from the config list)", true).getBoolean();
        fracSimple = config.get("Mining", "Use simplified fracturing (always fractures all 6 adjacent blocks)", false).getBoolean();
        String[] defaultOres = new String[]{Blocks.field_150365_q.getRegistryName().toString(), Blocks.field_150366_p.getRegistryName().toString(), Blocks.field_150352_o.getRegistryName().toString(), Blocks.field_150369_x.getRegistryName().toString(), Blocks.field_150482_ag.getRegistryName().toString(), Blocks.field_150412_bA.getRegistryName().toString()};
        String[] oresFrac = config.get("Mining", "Blocks which fracture adjacent stone when mined", defaultOres).getStringList();
        if (miningOreFractures) {
            for (String string : oresFrac) {
                Block state = GameplayConfig.getBlockFromString((String)string);
                BlockSets.oreAndFractures.add(state);
            }
        }
        customExplosion = config.get("Explosives", "Override explosions with custom explosions", true).getBoolean();
        explosionFractures = config.get("Explosives", "Explosions fracture stone", true).getBoolean();
        expLvlAatomize = config.get("Explosives", "Explosion level above which blocks atomize, and below which they drop", 5).getDouble();
        expLvlDrop = config.get("Explosives", "Explosion level above which blocks drop, and below which they fracture (if fracturing on- if off nothing happens below)", 1).getDouble();
        creeperUpConstant = config.get("Explosives", "Creeper upward modifier, increase to have creeper explosions explode more upwards", 1.5).getDouble() * 100.0;
        explosionDamageMod = config.get("Explosives", "Explosion entity damage percentage modifier", 100).getDouble() / 1000.0;
        explosionForceMod = config.get("Explosives", "Explosion entity force percentage modifier", 100).getDouble() / 500.0;
        String[] deffall = new String[]{"minecraft:dirt@50", "minecraft:cobblestone@75", "minecraft:mossy_cobblestone@90", "minecraft:sand@10", "minecraft:soul_sand@10", "minecraft:gravel@20", "minecraft:snow@40"};
        if (Core.UBC) {
            String[] UBCdeffall = new String[]{"minecraft:dirt@50", "minecraft:cobblestone@75", "minecraft:mossy_cobblestone@90", "minecraft:sand@10", "minecraft:soul_sand@10", "minecraft:gravel@20", "minecraft:snow@40", UBCCompat.IgneousCobblestone[0].func_177230_c().getRegistryName() + "@90", UBCCompat.MetamorphicCobblestone[0].func_177230_c().getRegistryName() + "@85", WTFBlocks.ubcSand.getRegistryName() + "@10"};
            deffall = UBCdeffall;
        }
        gravity = config.get("Gravity", "Enable Gravity for additional blocks", true).getBoolean();
        String[] fallingBlocks = config.get("Gravity", "blockName@percentStability (lower means less stable)", deffall).getStringList();
        if (gravity) {
            for (String blockAndStability : fallingBlocks) {
                Block block = GameplayConfig.getBlockFromString((String)blockAndStability.split("@")[0]);
                float stability = Integer.parseInt(blockAndStability.split("@")[1]);
                BlockSets.fallingBlocks.put(block, Float.valueOf(stability / 100.0f));
            }
        }
        fallingBlocksDamage = config.get("Gravity", "Enable damage from blocks", true).getBoolean();
        antiNerdPole = config.get("Gravity", "NerdPole Prevention: Prevent indefinite stacking of non-stable blocks (causes them to slide off)", true).getBoolean();
        String torch = "Finite Torches";
        torchLifespan = config.get(torch, "Chance in 100 per block tick (avg every 45 seconds) that an unattended torch will go out, 0 disables torches going out, -1 prevents torch replacement entirely", 20).getInt();
        torchRange = config.get(torch, "Number of blocks a player must be within to prevent a torch from going out", 20).getInt();
        relightTorchByHand = config.get(torch, "Torches can be relit by hand (true), or require flint and steel (false)", true).getBoolean();
        replaceTorch = config.get(torch, "0 Replace vanilla torches with finite torches", false).getBoolean();
        featherDrop = config.get("Drops", "Average number of minutes between chickens dropping feathers", 30).getInt() * 20 * 60;
        stickDrop = config.get("Drops", "Percentage of leaf blocks that drop sticks", 50).getInt();
        mobDropsReqPlayer = config.get("Drops", "When not killed by a player, mobs only drop items this percentage of the time", 25).getInt();
        appleCoreConstant = config.get("Crop Growth Rate", "Growth rate percent modifier for crops", 10).getDouble() / 100.0;
        plantGrowthMod = config.get("Crop Growth Rate", "Modify crop growth rates", true).getBoolean();
        homescroll = config.get("Loot and Crafting", "Enable home scrolls", true).getBoolean();
        wcictable = config.get("Loot and Crafting", "Enable Crafting Recipe Table", true).getBoolean();
        wcictable = config.get("Loot and Crafting", "Enable Netherrack --> Sulfur recipe", true).getBoolean();
        removeVanillaTools = config.get("Loot and Crafting", "Remove recipes for vanilla tools (Requires Tinkers Construct to be installed)", false).getBoolean();
        waterControl = config.get("Other", "Prevent infinite water source blocks outside biomes with the WET type", false).getBoolean();
        childZombie = config.get("Other", "Prevent spawning of baby zombies", false).getBoolean();
        config.save();
    }

    static {
        config = new Configuration(new File("config/WTF-Expedition/WTFGameplay.cfg"));
    }
}

