/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.network;

import io.netty.buffer.ByteBuf;
import net.cerulan.healthhungertweaks.HealthHungerTweaks;
import net.cerulan.healthhungertweaks.capability.healthbox.HealthBoxCapabilityHandler;
import net.cerulan.healthhungertweaks.capability.healthbox.IHealthBoxCapability;
import net.cerulan.healthhungertweaks.item.ModItems;
import net.cerulan.healthhungertweaks.network.HealthHungerPacketHandler;
import net.cerulan.healthhungertweaks.network.MessageSyncHealthBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageWithdrawKits
implements IMessage {
    private int kit = 0;
    private int amount = 0;

    public MessageWithdrawKits() {
    }

    public MessageWithdrawKits(int kit, int amount) {
        this.kit = kit;
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        this.kit = buf.readInt();
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.kit);
        buf.writeInt(this.amount);
    }

    public static class MessageWithdrawKitsHandler
    implements IMessageHandler<MessageWithdrawKits, IMessage> {
        public IMessage onMessage(MessageWithdrawKits message, MessageContext ctx) {
            HealthHungerTweaks.sidedProxy.getThreadFromContext(ctx).func_152344_a(() -> {
                IHealthBoxCapability healthbox = (IHealthBoxCapability)HealthHungerTweaks.sidedProxy.getPlayerEntity(ctx).getCapability(HealthBoxCapabilityHandler.HEALTH_BOX, null);
                if (message.amount > 0) {
                    int[] kits = healthbox.getHealthKits();
                    int kitindex = MathHelper.func_76125_a((int)message.kit, (int)0, (int)2);
                    int removeAmount = MathHelper.func_76125_a((int)message.amount, (int)0, (int)Math.min(kits[kitindex], 64));
                    kits[kitindex] = kits[kitindex] - removeAmount;
                    healthbox.setHealthKits(kits);
                    EntityPlayerMP ply = ctx.getServerHandler().field_147369_b;
                    ply.field_70170_p.func_72838_d((Entity)new EntityItem(ply.field_70170_p, ply.field_70165_t, ply.field_70163_u, ply.field_70161_v, new ItemStack((Item)ModItems.itemHealthKit, removeAmount, kitindex)));
                    HealthHungerPacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHealthBox(healthbox.getHealthKits(), healthbox.getCooldown()), ctx.getServerHandler().field_147369_b);
                }
            });
            return null;
        }
    }
}

