/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.network;

import io.netty.buffer.ByteBuf;
import net.cerulan.healthhungertweaks.HealthHungerTweaks;
import net.cerulan.healthhungertweaks.HealthKitStats;
import net.cerulan.healthhungertweaks.capability.healthbox.HealthBoxCapabilityHandler;
import net.cerulan.healthhungertweaks.capability.healthbox.IHealthBoxCapability;
import net.cerulan.healthhungertweaks.network.HealthHungerPacketHandler;
import net.cerulan.healthhungertweaks.network.MessageSyncHealthBox;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUseHealthKit
implements IMessage {
    private int kit;

    public MessageUseHealthKit() {
    }

    public MessageUseHealthKit(int kit) {
        this.kit = kit;
    }

    public void fromBytes(ByteBuf buf) {
        this.kit = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.kit);
    }

    public static class MessageUseHealthKitHandler
    implements IMessageHandler<MessageUseHealthKit, IMessage> {
        public IMessage onMessage(MessageUseHealthKit message, MessageContext ctx) {
            HealthHungerTweaks.sidedProxy.getThreadFromContext(ctx).func_152344_a(() -> {
                EntityPlayerMP pl = ctx.getServerHandler().field_147369_b;
                IHealthBoxCapability healthbox = (IHealthBoxCapability)pl.getCapability(HealthBoxCapabilityHandler.HEALTH_BOX, null);
                int[] kits = healthbox.getHealthKits();
                int useKit = -1;
                if (message.kit == -1 && healthbox.getCooldown() == 0) {
                    int searchkit;
                    int prelimKit = -1;
                    float health = pl.func_110143_aJ();
                    if (health >= pl.func_110138_aP() - HealthKitStats.PRIMITIVE.getRestored()) {
                        prelimKit = 0;
                    } else if (health >= pl.func_110138_aP() - HealthKitStats.STANDARD.getRestored()) {
                        prelimKit = 1;
                    } else if (health > 0.0f) {
                        prelimKit = 2;
                    }
                    int maxkit = 2;
                    boolean minkit = false;
                    boolean foundkit = false;
                    int resultkit = -1;
                    for (searchkit = prelimKit; searchkit <= 2 && !foundkit; ++searchkit) {
                        if (kits[searchkit] <= 0) continue;
                        foundkit = true;
                        resultkit = searchkit;
                    }
                    if (!foundkit) {
                        for (searchkit = prelimKit; searchkit >= 0 && !foundkit; --searchkit) {
                            if (kits[searchkit] <= 0) continue;
                            foundkit = true;
                            resultkit = searchkit;
                        }
                    }
                    useKit = resultkit;
                } else if (message.kit >= 0 && message.kit <= 2 && healthbox.getCooldown() == 0 && kits[message.kit] > 0) {
                    useKit = message.kit;
                }
                if (useKit != -1) {
                    kits[useKit] = kits[useKit] - 1;
                    healthbox.setHealthKits(kits);
                    healthbox.setCooldown(HealthHungerTweaks.instance.configHandler.getHealthKitCooldown());
                    HealthHungerPacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHealthBox(healthbox.getHealthKits(), healthbox.getCooldown()), ctx.getServerHandler().field_147369_b);
                    HealthKitStats stats = HealthKitStats.values()[useKit];
                    float healAmount = stats.getRestored();
                    healAmount = MathHelper.func_76131_a((float)healAmount, (float)0.0f, (float)(pl.func_110138_aP() - pl.func_110143_aJ()));
                    pl.func_70691_i(healAmount);
                    TextComponentString text = new TextComponentString(new TextComponentTranslation("healthkit.useHealthKit", new Object[0]).func_150254_d().replace("${item}", new TextComponentTranslation(String.format("item.healthKit.%1$d.name", useKit), new Object[0]).func_150254_d()));
                    text.func_150256_b().func_150238_a(TextFormatting.AQUA);
                    pl.func_145747_a((ITextComponent)text);
                }
            });
            return null;
        }
    }
}

