/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.network;

import io.netty.buffer.ByteBuf;
import net.cerulan.healthhungertweaks.HealthHungerTweaks;
import net.cerulan.healthhungertweaks.capability.healthbox.HealthBoxCapabilityHandler;
import net.cerulan.healthhungertweaks.capability.healthbox.IHealthBoxCapability;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncHealthBox
implements IMessage {
    private int[] health;
    private int cooldown;

    public MessageSyncHealthBox() {
    }

    public MessageSyncHealthBox(int[] health, int cooldown) {
        this.health = health;
        this.cooldown = cooldown;
    }

    public void fromBytes(ByteBuf buf) {
        this.health = new int[]{buf.readInt(), buf.readInt(), buf.readInt()};
        this.cooldown = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        for (int i = 0; i < 3; ++i) {
            buf.writeInt(this.health[i]);
        }
        buf.writeInt(this.cooldown);
    }

    public static class MessageSyncHealthBoxHandler
    implements IMessageHandler<MessageSyncHealthBox, IMessage> {
        public IMessage onMessage(MessageSyncHealthBox message, MessageContext ctx) {
            HealthHungerTweaks.sidedProxy.getThreadFromContext(ctx).func_152344_a(() -> {
                EntityPlayer pl = HealthHungerTweaks.sidedProxy.getPlayerEntity(ctx);
                IHealthBoxCapability cap = (IHealthBoxCapability)pl.getCapability(HealthBoxCapabilityHandler.HEALTH_BOX, null);
                cap.setHealthKits(message.health);
                cap.setCooldown(message.cooldown);
            });
            return null;
        }
    }
}

