/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.handler;

import net.cerulan.healthhungertweaks.HealthHungerTweaks;
import net.cerulan.healthhungertweaks.capability.healthbox.HealthBoxCapabilityHandler;
import net.cerulan.healthhungertweaks.capability.healthbox.IHealthBoxCapability;
import net.cerulan.healthhungertweaks.capability.healthregen.HealthRegenCapabilityHandler;
import net.cerulan.healthhungertweaks.capability.healthregen.IHealthRegenCapability;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;

public class HealthHungerHandler {
    @SubscribeEvent
    public void allowNormalRegen(HealthRegenEvent.AllowRegen event) {
        this.allowRegen((HealthRegenEvent)event);
    }

    @SubscribeEvent
    public void allowSaturatedRegen(HealthRegenEvent.AllowSaturatedRegen event) {
        this.allowRegen((HealthRegenEvent)event);
    }

    private void allowRegen(HealthRegenEvent event) {
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public void allowExhaustion(ExhaustionEvent.AllowExhaustion event) {
        if (event.player.func_70644_a((Potion)HealthHungerTweaks.sidedProxy.potionSatiated)) {
            event.setResult(Event.Result.DENY);
        } else {
            event.setResult(Event.Result.DEFAULT);
        }
    }

    @SubscribeEvent
    public void getMaxExhaustion(ExhaustionEvent.GetMaxExhaustion event) {
        event.maxExhaustionLevel = (float)((double)event.maxExhaustionLevel * HealthHungerTweaks.instance.configHandler.getExhaustionModifier());
    }

    @SubscribeEvent
    public void onFoodEaten(FoodEvent.FoodEaten event) {
        if (HealthHungerTweaks.instance.configHandler.shouldSate()) {
            int ticks = event.foodValues.hunger * HealthHungerTweaks.instance.configHandler.getSatiatedDuration();
            event.player.func_70690_d(new PotionEffect((Potion)HealthHungerTweaks.sidedProxy.potionSatiated, ticks, 0, false, true));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            IHealthBoxCapability hBoxCap;
            if (event.player.hasCapability(HealthBoxCapabilityHandler.HEALTH_BOX, null) && (hBoxCap = (IHealthBoxCapability)event.player.getCapability(HealthBoxCapabilityHandler.HEALTH_BOX, null)).getCooldown() > 0) {
                hBoxCap.setCooldown(hBoxCap.getCooldown() - 1);
            }
            if (event.player.hasCapability(HealthRegenCapabilityHandler.HEALTH_REGEN, null)) {
                IHealthRegenCapability hRegenCap = (IHealthRegenCapability)event.player.getCapability(HealthRegenCapabilityHandler.HEALTH_REGEN, null);
                int untilStart = hRegenCap.getTicksUntilRegenStart();
                int untilNext = hRegenCap.getTicksUntilNextRegen();
                if (event.player.func_71024_bL().func_75116_a() >= HealthHungerTweaks.instance.configHandler.getMinimumHunger() && event.player.func_110143_aJ() < event.player.func_110138_aP()) {
                    if (untilStart > 0) {
                        --untilStart;
                    } else if (untilStart == 0 && untilNext > 0) {
                        --untilNext;
                    } else if (untilStart == 0 && untilNext == 0) {
                        untilNext = HealthHungerTweaks.instance.configHandler.getDelayBetweenTicks();
                        if (!event.player.field_70170_p.field_72995_K && event.player.func_110143_aJ() < event.player.func_110138_aP()) {
                            event.player.func_70691_i(1.0f);
                        }
                    }
                } else {
                    untilStart = HealthHungerTweaks.instance.configHandler.getDelayUntilStart();
                }
                hRegenCap.setData(untilStart, untilNext);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntity()).hasCapability(HealthRegenCapabilityHandler.HEALTH_REGEN, null)) {
            IHealthRegenCapability cap = (IHealthRegenCapability)player.getCapability(HealthRegenCapabilityHandler.HEALTH_REGEN, null);
            cap.setData(HealthHungerTweaks.instance.configHandler.getDelayUntilStart(), HealthHungerTweaks.instance.configHandler.getDelayBetweenTicks());
        }
    }
}

