/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.handler;

import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private Configuration config;
    private boolean doSatiation;
    private int satiatedDuration;
    private double exhaustionModifier;
    private int maxUnrecoverableHealth;
    private boolean useDmgWhitelist;
    private List<String> damageWhitelist;
    private List<String> damageBlacklist;
    private int kitCooldown;
    private int showCooldownMode;
    private int cdX;
    private int cdY;
    private boolean screenDarkenWhenInjure;
    private boolean disableRegularRegen;
    private int delayUntilStart;
    private int delayBetweenTicks;
    private int minimumHunger;

    public ConfigHandler(Configuration config) {
        this.config = config;
    }

    public void load() {
        this.showCooldownMode = this.config.get("client", "showCooldownMode", 2, "Sets the mode that determines how the health kit cooldown will be displayed. 0=Not At All, 1=Only Icon, 2=Icon + Time Remaining").getInt();
        this.cdX = this.config.get("client", "cooldownX", 5, "The X Coordinate of the Cooldown Indicator").getInt();
        this.cdY = this.config.get("client", "cooldownY", 5, "The Y Coordinate of the Cooldown Indicator").getInt();
        this.screenDarkenWhenInjure = this.config.get("client", "screenDarken", true, "Whether or not the screen should darken when injured").getBoolean();
        this.doSatiation = this.config.get("satiated", "enableSatiated", true, "Toggles whether eating food gives a satiated effect that disabled food drain for the duration.").getBoolean();
        this.satiatedDuration = this.config.get("satiated", "satiatedDuration", 600, "This value will be multipled to the food value of the food to get the duration (in ticks) of the satiated effect.").getInt();
        this.exhaustionModifier = this.config.get("exhaustion", "exhaustionModifier", 2.0, "An exhaustion modifier that will be multiplied to the default maximum exhausion. Higher values mean slower food drain.").getDouble();
        this.disableRegularRegen = this.config.get("mending", "disableRegularRegen", true, "Toggles whether regular regen (from food) should be disabled, and players must use health kits. Recommended if food is made easier.").getBoolean();
        this.delayUntilStart = this.config.get("mending", "delayUntilStart", 200, "The delay (in ticks) before a player will begin to regenerate health. Negative values disable this functionality, forcing players to rely solely on health kits or potions.").getInt();
        this.delayBetweenTicks = this.config.get("mending", "delayBetweenTicks", 10, "The delay (in ticks) between each half-heart restored.").getInt();
        this.minimumHunger = this.config.get("mending", "minimumHunger", 6, "The minimum hunger (in half-shanks) necessary to be able to heal.").getInt();
        this.kitCooldown = this.config.get("mending", "healthKitCooldown", 600, "The cooldown period (in ticks) while a player may not use a health kit after previously using one.").getInt();
        this.config.save();
    }

    public boolean damageMatchesList(String dmgSrc) {
        if (this.useDmgWhitelist) {
            return this.damageWhitelist.contains(dmgSrc);
        }
        return !this.damageBlacklist.contains(dmgSrc);
    }

    public int getMaxUnrecoverableHealth() {
        return this.maxUnrecoverableHealth;
    }

    public double getExhaustionModifier() {
        return this.exhaustionModifier;
    }

    public boolean shouldSate() {
        return this.doSatiation;
    }

    public int getSatiatedDuration() {
        return this.satiatedDuration;
    }

    public boolean shouldDisableRegularRegen() {
        return this.disableRegularRegen;
    }

    public int getHealthKitCooldown() {
        return this.kitCooldown;
    }

    public int getShowCooldownMode() {
        return this.showCooldownMode;
    }

    public int getCooldownX() {
        return this.cdX;
    }

    public int getCooldownY() {
        return this.cdY;
    }

    public boolean shouldScreenDarkenWhenInjured() {
        return this.screenDarkenWhenInjure;
    }

    public int getDelayUntilStart() {
        return this.delayUntilStart;
    }

    public int getDelayBetweenTicks() {
        return this.delayBetweenTicks;
    }

    public int getMinimumHunger() {
        return this.minimumHunger;
    }
}

