/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.capability.healthregen;

import net.cerulan.healthhungertweaks.capability.healthregen.HealthRegenCapability;
import net.cerulan.healthhungertweaks.capability.healthregen.IHealthRegenCapability;
import net.cerulan.healthhungertweaks.network.HealthHungerPacketHandler;
import net.cerulan.healthhungertweaks.network.MessageSyncHealthRegen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HealthRegenCapabilityHandler {
    @CapabilityInject(value=IHealthRegenCapability.class)
    public static final Capability<IHealthRegenCapability> HEALTH_REGEN = null;

    @SubscribeEvent
    public void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("healthhungertweaks", "health_regen"), (ICapabilityProvider)new ProviderHealthRegen());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int ticksUntilStart = ((IHealthRegenCapability)player.getCapability(HEALTH_REGEN, null)).getTicksUntilRegenStart();
            int ticksUntilRegen = ((IHealthRegenCapability)player.getCapability(HEALTH_REGEN, null)).getTicksUntilNextRegen();
            HealthHungerPacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHealthRegen(ticksUntilStart, ticksUntilRegen), player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            IHealthRegenCapability cap = (IHealthRegenCapability)event.getOriginal().getCapability(HEALTH_REGEN, null);
            ((IHealthRegenCapability)event.getEntityPlayer().getCapability(HEALTH_REGEN, null)).setData(cap.getTicksUntilRegenStart(), cap.getTicksUntilNextRegen());
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && !event.getEntity().field_70170_p.field_72995_K) {
            IHealthRegenCapability cap = (IHealthRegenCapability)event.getEntity().getCapability(HEALTH_REGEN, null);
            int ticksUntilStart = cap.getTicksUntilRegenStart();
            int ticksUntilRegen = cap.getTicksUntilNextRegen();
            HealthHungerPacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHealthRegen(ticksUntilStart, ticksUntilRegen), (EntityPlayerMP)event.getEntity());
        }
    }

    public void register() {
        CapabilityManager.INSTANCE.register(IHealthRegenCapability.class, (Capability.IStorage)new HealthRegenCapability.HealthRegenStorage(), HealthRegenCapability.class);
    }

    class ProviderHealthRegen
    implements ICapabilitySerializable<NBTBase> {
        private IHealthRegenCapability instance = (IHealthRegenCapability)HEALTH_REGEN.getDefaultInstance();

        ProviderHealthRegen() {
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return HEALTH_REGEN != null && capability == HEALTH_REGEN;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)HEALTH_REGEN.cast((Object)this.instance);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return HEALTH_REGEN.getStorage().writeNBT(HEALTH_REGEN, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            HEALTH_REGEN.getStorage().readNBT(HEALTH_REGEN, (Object)this.instance, null, nbt);
        }
    }
}

