/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.capability.healthbox;

import net.cerulan.healthhungertweaks.HealthHungerTweaks;
import net.cerulan.healthhungertweaks.capability.healthbox.IHealthBoxCapability;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class HealthBoxStorage
implements Capability.IStorage<IHealthBoxCapability> {
    public NBTBase writeNBT(Capability<IHealthBoxCapability> capability, IHealthBoxCapability instance, EnumFacing side) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("kits", instance.getHealthKits());
        nbt.func_74768_a("cooldown", instance.getCooldown());
        return nbt;
    }

    public void readNBT(Capability<IHealthBoxCapability> capability, IHealthBoxCapability instance, EnumFacing side, NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            int[] kits = ((NBTTagCompound)nbt).func_74759_k("kits");
            try {
                System.arraycopy(kits, 0, instance.getHealthKits(), 0, 3);
            }
            catch (Exception ex) {
                HealthHungerTweaks.Log.info("Error occurred when reading Health Box data.");
                ex.printStackTrace();
            }
            int cooldown = ((NBTTagCompound)nbt).func_74762_e("cooldown");
            instance.setCooldown(cooldown);
        } else if (nbt instanceof NBTTagIntArray) {
            try {
                NBTTagIntArray ia = (NBTTagIntArray)nbt;
                System.arraycopy(ia.func_150302_c(), 0, instance.getHealthKits(), 0, 3);
                instance.setCooldown(0);
            }
            catch (Exception ex) {
                HealthHungerTweaks.Log.info("Error occurred when reading Health Box data.");
                ex.printStackTrace();
            }
        }
    }
}

