/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.healthhungertweaks.capability.healthbox;

import net.cerulan.healthhungertweaks.capability.healthbox.HealthBoxCapability;
import net.cerulan.healthhungertweaks.capability.healthbox.HealthBoxStorage;
import net.cerulan.healthhungertweaks.capability.healthbox.IHealthBoxCapability;
import net.cerulan.healthhungertweaks.network.HealthHungerPacketHandler;
import net.cerulan.healthhungertweaks.network.MessageSyncHealthBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HealthBoxCapabilityHandler {
    @CapabilityInject(value=IHealthBoxCapability.class)
    public static final Capability<IHealthBoxCapability> HEALTH_BOX = null;

    @SubscribeEvent
    public void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("healthhungertweaks", "health_box"), (ICapabilityProvider)new ProviderHealthBox());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int[] health = ((IHealthBoxCapability)player.getCapability(HEALTH_BOX, null)).getHealthKits();
            int cd = ((IHealthBoxCapability)player.getCapability(HEALTH_BOX, null)).getCooldown();
            HealthHungerPacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHealthBox(health, cd), player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            IHealthBoxCapability cap = (IHealthBoxCapability)event.getOriginal().getCapability(HEALTH_BOX, null);
            ((IHealthBoxCapability)event.getEntityPlayer().getCapability(HEALTH_BOX, null)).setHealthKits(cap.getHealthKits());
            ((IHealthBoxCapability)event.getEntityPlayer().getCapability(HEALTH_BOX, null)).setCooldown(0);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && !event.getEntity().field_70170_p.field_72995_K) {
            IHealthBoxCapability cap = (IHealthBoxCapability)event.getEntity().getCapability(HEALTH_BOX, null);
            int[] health = cap.getHealthKits();
            int cd = cap.getCooldown();
            HealthHungerPacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncHealthBox(health, cd), (EntityPlayerMP)event.getEntity());
        }
    }

    public void register() {
        CapabilityManager.INSTANCE.register(IHealthBoxCapability.class, (Capability.IStorage)new HealthBoxStorage(), HealthBoxCapability.class);
    }

    class ProviderHealthBox
    implements ICapabilitySerializable<NBTBase> {
        private IHealthBoxCapability instance = (IHealthBoxCapability)HEALTH_BOX.getDefaultInstance();

        ProviderHealthBox() {
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return HEALTH_BOX != null && capability == HEALTH_BOX;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)HEALTH_BOX.cast((Object)this.instance);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return HEALTH_BOX.getStorage().writeNBT(HEALTH_BOX, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            HEALTH_BOX.getStorage().readNBT(HEALTH_BOX, (Object)this.instance, null, nbt);
        }
    }
}

