/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither.powerups;

import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.api.IPowerUpEffect;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.wither.powerups.BasePowerUp;
import thor12022.hardcorewither.wither.powerups.BasePowerUpEffect;

@Configurable
public class PowerUpTeleport
extends BasePowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 20;
    private static final int DEFAULT_MIN_LEVEL = 4;
    @Config(minFloat=1.0f, maxFloat=10.0f)
    private static float teleportFrequencyMultiplier = 1.1f;
    @Config(minFloat=0.0f, maxFloat=10.0f, comment="0 is not random, 1 is more random")
    private static float teleportRandomness = 0.5f;
    @Config(minInt=20, comment="Avg number of ticks between teleport attempt")
    private static int teleportFequencyBase = 100;
    @Config(minInt=0, maxInt=10, comment="Number of ticks in a row to retry a teleport attempt")
    private static int teleportRetryTicks = 5;
    @Config(minFloat=0.0f, maxFloat=10.0f, comment="0 is prefect")
    private static float teleportInaccuracy = 4.0f;
    @Config(comment="Less likely that the Wither may get stuck, but may affect performance")
    private static boolean requireLineOfSightToTarget = false;

    public PowerUpTeleport() {
        super(4, 20);
        HardcoreWither.CONFIG.register(this);
    }

    @Override
    public void updateWither(IPowerUpEffect data) {
        Entity target;
        int targetId;
        Data stateData = (Data)data;
        if (stateData.wither.func_82212_n() <= 0 && stateData.wither.field_70170_p.func_82737_E() > stateData.nextTick && (targetId = stateData.wither.func_82203_t(0)) != -1 && (target = stateData.wither.field_70170_p.func_73045_a(targetId)) != null) {
            int meanDistance = stateData.wither.func_70068_e(target) >= 256.0 ? 16 : 8;
            double teleportXPos = target.field_70165_t + (double)(meanDistance * (HardcoreWither.RAND.nextBoolean() ? 1 : -1)) + (double)(teleportInaccuracy * (HardcoreWither.RAND.nextFloat() * 2.0f - 1.0f));
            double teleportYPos = target.field_70163_u + (double)(meanDistance * (HardcoreWither.RAND.nextBoolean() ? 1 : -1)) + (double)(teleportInaccuracy * (HardcoreWither.RAND.nextFloat() * 2.0f - 1.0f));
            double teleportZPos = target.field_70161_v + (double)(meanDistance * (HardcoreWither.RAND.nextBoolean() ? 1 : -1)) + (double)(teleportInaccuracy * (HardcoreWither.RAND.nextFloat() * 2.0f - 1.0f));
            if (teleportYPos < 0.0) {
                teleportYPos = 0.0;
            }
            boolean successfulTeleport = true;
            if (requireLineOfSightToTarget && stateData.getWither().func_70638_az() != null) {
                Vec3d vecWither = new Vec3d(stateData.getWither().field_70165_t, stateData.getWither().field_70163_u + (double)stateData.getWither().func_70047_e(), stateData.getWither().field_70161_v);
                Vec3d vecTarget = new Vec3d(stateData.getWither().func_70638_az().field_70165_t, stateData.getWither().func_70638_az().field_70163_u + (double)stateData.getWither().func_70638_az().func_70047_e(), stateData.getWither().func_70638_az().field_70161_v);
                boolean bl = successfulTeleport = stateData.getWither().func_130014_f_().func_147447_a(vecWither, vecTarget, false, true, false) == null;
            }
            if (successfulTeleport && (successfulTeleport = stateData.wither.func_184595_k(teleportXPos, teleportYPos, teleportZPos))) {
                stateData.getWither().func_130014_f_().func_184148_a(null, stateData.getWither().field_70169_q, stateData.getWither().field_70167_r, stateData.getWither().field_70166_s, SoundEvents.field_187534_aX, stateData.getWither().func_184176_by(), 1.0f, 1.0f);
                stateData.getWither().func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            stateData.setNextRandomTick(successfulTeleport);
        }
    }

    @Override
    public void witherDied(IPowerUpEffect data) {
    }

    @Override
    public IPowerUpEffect getPowerUpEffect(EntityWither wither, int strength) {
        Data data = new Data(wither);
        data.setStrength(strength);
        data.setNextRandomTick();
        return data;
    }

    @Override
    public IPowerUpEffect restorePowerUp(EntityWither wither, NBTTagCompound stateNbt) {
        Data data = new Data(wither);
        data.deserializeNBT(stateNbt);
        return data;
    }

    protected class Data
    extends BasePowerUpEffect {
        long nextTick;
        int retryNumber;

        Data(EntityWither wither) {
            super(wither, PowerUpTeleport.this);
            this.retryNumber = 0;
        }

        void setNextRandomTick() {
            this.setNextRandomTick(true);
        }

        void setNextRandomTick(boolean successfulAttempt) {
            if (successfulAttempt || this.retryNumber >= teleportRetryTicks) {
                this.retryNumber = 0;
                long strengthBasedTick = (long)((float)teleportFequencyBase / ((float)this.strength * teleportFrequencyMultiplier));
                long modifier = (long)(HardcoreWither.RAND.nextGaussian() * (double)teleportRandomness * (double)strengthBasedTick);
                this.nextTick = this.wither.func_130014_f_().func_82737_E() + strengthBasedTick + modifier;
            } else if (this.retryNumber < teleportRetryTicks) {
                ++this.retryNumber;
                this.nextTick = this.wither.func_130014_f_().func_82737_E() + 1L;
            }
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("nextTick", this.nextTick);
            nbt.func_74768_a("retryNumber", this.retryNumber);
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            this.nextTick = nbt.func_74763_f("nextTick");
            this.retryNumber = nbt.func_74762_e("retryNumber");
        }
    }
}

