/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither.powerups;

import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.api.IPowerUpEffect;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.wither.powerups.BasePowerUp;
import thor12022.hardcorewither.wither.powerups.BasePowerUpEffect;

@Configurable
public class PowerUpLightning
extends BasePowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 20;
    private static final int DEFAULT_MIN_LEVEL = 1;
    @Config(minFloat=1.0f, maxFloat=5.0f)
    private static float lightningFrequencyMultiplier = 1.1f;
    @Config(minFloat=1.0f, maxFloat=5.0f, comment="0 is not random, 1 is more random")
    private static float lightningRandomness = 0.5f;
    @Config(minFloat=1.0f, maxFloat=5.0f, comment="Avg number of ticks between lightning")
    private static int lightningFequencyBase = 100;
    @Config(minFloat=0.0f, maxFloat=5.0f, comment="0 is prefect")
    private static float lightningInaccuracy = 0.5f;

    public PowerUpLightning() {
        super(1, 20);
        HardcoreWither.CONFIG.register(this);
    }

    @Override
    public void updateWither(IPowerUpEffect effect) {
        Entity target;
        int targetId;
        Data lightningData = (Data)effect;
        if (lightningData.getWither().field_70170_p.func_82737_E() > lightningData.nextTick && (targetId = lightningData.getWither().func_82203_t(0)) != -1 && (target = lightningData.getWither().field_70170_p.func_73045_a(targetId)) != null) {
            double lightningXPos = target.field_70142_S + 8.0 * HardcoreWither.RAND.nextGaussian() * (double)lightningInaccuracy;
            double lightningYPos = target.field_70137_T + 8.0 * HardcoreWither.RAND.nextGaussian() * (double)lightningInaccuracy;
            double lightningZPos = target.field_70136_U + 8.0 * HardcoreWither.RAND.nextGaussian() * (double)lightningInaccuracy;
            lightningData.getWither().field_70170_p.func_72942_c((Entity)new EntityLightningBolt(lightningData.getWither().field_70170_p, lightningXPos, lightningYPos, lightningZPos, false));
            lightningData.setNextRandomTick();
        }
    }

    @Override
    public void witherDied(IPowerUpEffect data) {
    }

    @Override
    public IPowerUpEffect getPowerUpEffect(EntityWither wither, int strength) {
        Data data = new Data(wither);
        data.setStrength(strength);
        data.setNextRandomTick();
        return data;
    }

    @Override
    public IPowerUpEffect restorePowerUp(EntityWither wither, NBTTagCompound stateNbt) {
        Data data = new Data(wither);
        data.deserializeNBT(stateNbt);
        return data;
    }

    protected class Data
    extends BasePowerUpEffect {
        long nextTick;

        Data(EntityWither wither) {
            super(wither, PowerUpLightning.this);
        }

        public long getNextTick() {
            return this.nextTick;
        }

        void setNextRandomTick() {
            long currentTick = this.wither.func_130014_f_().func_82737_E();
            long strengthBasedTick = (long)((float)lightningFequencyBase / ((float)this.strength * lightningFrequencyMultiplier));
            long modifier = (long)(HardcoreWither.RAND.nextGaussian() * (double)lightningRandomness * (double)strengthBasedTick);
            this.nextTick = currentTick + strengthBasedTick + modifier;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74772_a("nextTick", this.nextTick);
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            this.nextTick = nbt.func_74763_f("nextTick");
        }
    }
}

