/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither.powerups;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.nbt.NBTTagCompound;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.api.IPowerUpEffect;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.wither.powerups.BasePowerUp;
import thor12022.hardcorewither.wither.powerups.BasePowerUpEffect;

@Configurable
public class PowerUpHealthBoost
extends BasePowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 128;
    private static final int DEFAULT_MIN_LEVEL = 1;
    @Config(minFloat=1.0f, maxFloat=10.0f)
    private static float healthBoostMultiplier = 1.1f;

    protected static void updateWitherHealth(HealthBoostPowerUpEffect effect) {
        double newHealth = effect.initialHealth * (double)healthBoostMultiplier * (double)effect.strength;
        effect.wither.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(newHealth);
    }

    public PowerUpHealthBoost() {
        super(1, 128);
        HardcoreWither.CONFIG.register(this);
    }

    @Override
    public void updateWither(IPowerUpEffect data) {
        if (data.getWither().func_70613_aW() && data.getWither().func_82212_n() >= 20) {
            float baseHealth = (float)data.getWither().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            data.getWither().func_70691_i((baseHealth * 0.6666667f - 200.0f) / 200.0f);
        }
    }

    @Override
    public void witherDied(IPowerUpEffect data) {
    }

    @Override
    public IPowerUpEffect getPowerUpEffect(EntityWither wither, int strength) {
        HealthBoostPowerUpEffect data = new HealthBoostPowerUpEffect(wither);
        ((BasePowerUpEffect)data).setStrength(strength);
        return data;
    }

    @Override
    public IPowerUpEffect restorePowerUp(EntityWither wither, NBTTagCompound stateNbt) {
        HealthBoostPowerUpEffect data = new HealthBoostPowerUpEffect(wither);
        data.deserializeNBT(stateNbt);
        return data;
    }

    private class HealthBoostPowerUpEffect
    extends BasePowerUpEffect {
        final double initialHealth;

        public HealthBoostPowerUpEffect(EntityWither wither) {
            super(wither, PowerUpHealthBoost.this);
            this.initialHealth = wither.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        }

        @Override
        public void setStrength(int strength) {
            super.setStrength(strength);
            PowerUpHealthBoost.updateWitherHealth(this);
        }
    }
}

