/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither.powerups;

import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.nbt.NBTTagCompound;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.api.IPowerUpEffect;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.wither.powerups.BasePowerUp;
import thor12022.hardcorewither.wither.powerups.BasePowerUpEffect;

@Configurable
public class PowerUpDeathKnell
extends BasePowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 10;
    private static final int DEFAULT_MIN_LEVEL = 1;
    @Config(minFloat=0.0f, maxFloat=10.0f)
    private static float knellStrengthMultiplier = 0.6666667f;

    public PowerUpDeathKnell() {
        super(1, 10);
        HardcoreWither.CONFIG.register(this);
    }

    @Override
    public void updateWither(IPowerUpEffect data) {
    }

    @Override
    public void witherDied(IPowerUpEffect data) {
        EntityWither wither = data.getWither();
        wither.field_70170_p.func_72885_a((Entity)wither, wither.field_70165_t, wither.field_70163_u + (double)wither.func_70047_e(), wither.field_70161_v, 7.0f * knellStrengthMultiplier * (float)data.getStrength(), false, wither.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
    }

    @Override
    public IPowerUpEffect getPowerUpEffect(EntityWither wither, int strength) {
        BasePowerUpEffect data = new BasePowerUpEffect(wither, this);
        data.setStrength(strength);
        return data;
    }

    @Override
    public IPowerUpEffect restorePowerUp(EntityWither wither, NBTTagCompound stateNbt) {
        BasePowerUpEffect data = new BasePowerUpEffect(wither, this);
        data.deserializeNBT(stateNbt);
        return data;
    }
}

