/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither.powerups;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.api.IPowerUpEffect;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.util.ReflectionUtils;
import thor12022.hardcorewither.wither.powerups.BasePowerUp;
import thor12022.hardcorewither.wither.powerups.BasePowerUpEffect;

@Configurable
public class PowerUpDamageResistance
extends BasePowerUp {
    private static final int DEFAULT_MAX_STRENGTH = 3;
    private static final int DEFAULT_MIN_LEVEL = 1;
    private static MethodHandle onNewPotionEffectMethod;
    private static Field activePotionMapField;

    protected static void setResistancePotionEffect(EntityWither wither, int strength) {
        PotionEffect resistanceEffect = new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, strength);
        try {
            Map activePotionsMap = (Map)activePotionMapField.get(wither);
            if (activePotionsMap.containsKey(resistanceEffect.func_188419_a())) {
                activePotionsMap.remove(resistanceEffect.func_188419_a());
            }
            activePotionsMap.put(resistanceEffect.func_188419_a(), resistanceEffect);
            onNewPotionEffectMethod.invoke(wither, resistanceEffect);
        }
        catch (Throwable e) {
            HardcoreWither.LOGGER.error((Object)e);
        }
    }

    public PowerUpDamageResistance() {
        super(1, 3);
        HardcoreWither.CONFIG.register(this);
    }

    @Override
    public void updateWither(IPowerUpEffect data) {
    }

    @Override
    public void witherDied(IPowerUpEffect data) {
    }

    @Override
    public IPowerUpEffect getPowerUpEffect(EntityWither wither, int strength) {
        Data data = new Data(wither);
        ((BasePowerUpEffect)data).setStrength(strength);
        return data;
    }

    @Override
    public IPowerUpEffect restorePowerUp(EntityWither wither, NBTTagCompound stateNbt) {
        Data data = new Data(wither);
        data.deserializeNBT(stateNbt);
        return data;
    }

    static {
        try {
            onNewPotionEffectMethod = ReflectionUtils.findMethod(EntityLivingBase.class, new String[]{"func_70670_a", "onNewPotionEffect"}, PotionEffect.class);
        }
        catch (Exception exp) {
            HardcoreWither.LOGGER.error((Object)exp);
            onNewPotionEffectMethod = null;
        }
        try {
            activePotionMapField = ReflectionHelper.findField(EntityLivingBase.class, (String[])new String[]{"field_70713_bf", "activePotionsMap"});
            activePotionMapField.setAccessible(true);
        }
        catch (Exception excp) {
            HardcoreWither.LOGGER.error((Object)excp);
            activePotionMapField = null;
        }
    }

    private class Data
    extends BasePowerUpEffect {
        public Data(EntityWither wither) {
            super(wither, PowerUpDamageResistance.this);
        }

        @Override
        public void setStrength(int strength) {
            super.setStrength(strength);
            PowerUpDamageResistance.setResistancePotionEffect(this.wither, strength);
        }
    }
}

