/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither.powerups;

import net.minecraft.entity.boss.EntityWither;
import net.minecraft.nbt.NBTTagCompound;
import thor12022.hardcorewither.api.IPowerUp;
import thor12022.hardcorewither.api.IPowerUpEffect;

public class BasePowerUpEffect
implements IPowerUpEffect {
    protected final IPowerUp powerUp;
    protected final EntityWither wither;
    protected int strength;

    public BasePowerUpEffect(EntityWither wither, IPowerUp powerUp) {
        this.wither = wither;
        this.powerUp = powerUp;
    }

    @Override
    public void setStrength(int strength) {
        this.strength = strength;
    }

    @Override
    public int getStrength() {
        return this.strength;
    }

    @Override
    public void updateEffect() {
        this.powerUp.updateWither(this);
    }

    @Override
    public void onDied() {
        this.powerUp.witherDied(this);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("powerUpId", this.powerUp.getRegistryName().toString());
        tag.func_74768_a("strength", this.strength);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setStrength(nbt.func_74762_e("strength"));
    }

    @Override
    public IPowerUp getCreator() {
        return this.powerUp;
    }

    @Override
    public EntityWither getWither() {
        return this.wither;
    }
}

