/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither.powerups;

import net.minecraft.entity.boss.EntityWither;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thor12022.hardcorewither.api.IPowerUpEffect;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.wither.powerups.BasePowerUp;
import thor12022.hardcorewither.wither.powerups.BasePowerUpEffect;

@Configurable
abstract class AbstractPowerUpMinionSpawner
extends BasePowerUp {
    protected final String entityLocalizedName;
    @Config(maxInt=65535)
    protected int defaultDelay = 20;
    @Config(maxInt=65535)
    protected int defaultPlayerRange = 48;
    @Config(maxInt=65535)
    protected int defaultMaxEntities = 6;
    @Config(maxInt=65535)
    protected int defaultMinDelay = 600;
    @Config(maxInt=65535)
    protected int defaultMaxDelay = 800;
    @Config(maxInt=65535)
    protected int defaultSpawnCount = 4;
    @Config(maxInt=65535)
    protected int defaultSpawnRange = 4;
    @Config(minFloat=1.0f, maxFloat=10.0f, comment="Amount to increase Spawn Count by. 1.0 to never increase")
    protected static float spawnCountModifier = 1.1f;
    @Config(minFloat=0.0f, maxFloat=1.0f, comment="The smaller it is, the faster the delay decrease. 1.0 to never decrease")
    protected static float spawnDelayModifier = 0.8f;
    @Config(minFloat=1.0f, maxFloat=10.0f, comment="Amount to increase Max Entities by. 1.0 to never increase")
    protected static float maxEntitiesModifier = 1.1f;

    public AbstractPowerUpMinionSpawner(int minLevel, int maxStrength, String entityLocalizedName) {
        super(minLevel, maxStrength);
        this.entityLocalizedName = entityLocalizedName;
    }

    @Override
    public void updateWither(IPowerUpEffect data) {
        ((Data)data).spawner.func_98278_g();
    }

    @Override
    public void witherDied(IPowerUpEffect data) {
    }

    @Override
    public IPowerUpEffect getPowerUpEffect(EntityWither wither, int strength) {
        Data data = new Data(wither);
        data.setStrength(strength);
        data.resetSpawnerToData();
        return data;
    }

    @Override
    public IPowerUpEffect restorePowerUp(EntityWither wither, NBTTagCompound stateNbt) {
        Data data = new Data(wither);
        data.deserializeNBT(stateNbt);
        return data;
    }

    protected class Data
    extends BasePowerUpEffect {
        int delay;
        int playerRange;
        int maxEntities;
        int minDelay;
        int maxDelay;
        int spawnCount;
        int spawnRange;
        MobSpawnerBaseLogic spawner;

        Data(EntityWither wither) {
            super(wither, AbstractPowerUpMinionSpawner.this);
            this.spawner = new MobSpawnerBaseLogic(){

                public void func_98267_a(int id) {
                }

                public World func_98271_a() {
                    return Data.this.wither.field_70170_p;
                }

                public BlockPos func_177221_b() {
                    return Data.this.wither.func_180425_c();
                }
            };
        }

        protected void resetSpawnerToData() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a("Delay", (short)Math.round((float)AbstractPowerUpMinionSpawner.this.defaultDelay + spawnDelayModifier * (float)this.strength));
            nbt.func_74777_a("RequiredPlayerRange", (short)AbstractPowerUpMinionSpawner.this.defaultPlayerRange);
            nbt.func_74777_a("MaxNearbyEntities", (short)Math.round((float)AbstractPowerUpMinionSpawner.this.defaultMaxEntities + maxEntitiesModifier * (float)this.strength));
            nbt.func_74777_a("MinSpawnDelay", (short)Math.round((float)AbstractPowerUpMinionSpawner.this.defaultMinDelay + spawnDelayModifier * (float)this.strength));
            nbt.func_74777_a("MaxSpawnDelay", (short)Math.round((float)AbstractPowerUpMinionSpawner.this.defaultMaxDelay + spawnDelayModifier * (float)this.strength));
            nbt.func_74777_a("SpawnCount", (short)Math.round((float)AbstractPowerUpMinionSpawner.this.defaultSpawnCount + spawnCountModifier * (float)this.strength));
            nbt.func_74777_a("SpawnRange", (short)AbstractPowerUpMinionSpawner.this.defaultSpawnRange);
            this.spawner.func_98270_a(nbt);
            this.spawner.func_98272_a(AbstractPowerUpMinionSpawner.this.entityLocalizedName);
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            NBTTagCompound spawnerNbt = new NBTTagCompound();
            this.spawner.func_189530_b(spawnerNbt);
            nbt.func_74782_a("spawnerLogic", (NBTBase)spawnerNbt);
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            NBTTagCompound spawnerNbt = nbt.func_74775_l("spawnerLogic");
            this.spawner.func_98270_a(spawnerNbt);
            super.deserializeNBT(nbt);
        }

        @Override
        public void setStrength(int strength) {
            super.setStrength(strength);
            this.resetSpawnerToData();
        }
    }
}

