/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import thor12022.hardcorewither.HardcoreWither;

public class WitherWorldData
extends WorldSavedData {
    private static final int NBT_FORMAT = 2;
    private static final String NAME = "hardcorewither_witherData";
    private int largestPowerUp = 0;

    public static WitherWorldData loadWitherWorldSavedData(World world) {
        WitherWorldData data = null;
        if (world.field_73011_w.getDimension() == 0 && world.func_175693_T() != null) {
            try {
                data = (WitherWorldData)world.func_175693_T().func_75742_a(WitherWorldData.class, NAME);
                if (data == null) {
                    data = new WitherWorldData(NAME);
                    data.func_76185_a();
                    world.func_175693_T().func_75745_a(NAME, (WorldSavedData)data);
                }
            }
            catch (ClassCastException e) {
                HardcoreWither.LOGGER.error((Object)e);
                HardcoreWither.LOGGER.warn("Cannot properly get WitherWorldData");
            }
        }
        return data;
    }

    public WitherWorldData(String name) {
        super(name);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74768_a("formatVersion", 2);
        nbt.func_74768_a("largestPowerUp", this.largestPowerUp);
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int formatVersion = nbt.func_74762_e("formatVersion");
        if (formatVersion < 2) {
            HardcoreWither.LOGGER.warn("Detected old version of saved data. Withers' abilities will not convert to ", new Object[]{"2.2.3", " from older versions"});
        }
        this.largestPowerUp = nbt.func_74762_e("largestPowerUp");
    }

    int getLargestPowerUp() {
        return this.largestPowerUp;
    }

    void setLargestPowerUp(int size) {
        this.largestPowerUp = size;
    }
}

