/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.enchantment.EnchantmentRegistry;
import thor12022.hardcorewither.player.PlayerData;
import thor12022.hardcorewither.util.I18n;
import thor12022.hardcorewither.wither.PowerUpHelper;
import thor12022.hardcorewither.wither.WitherAffinityHelper;
import thor12022.hardcorewither.wither.WitherData;
import thor12022.hardcorewither.wither.WitherWorldData;

@Configurable(sectionName="Wither")
public class WitherHandler {
    @Config(comment="Will enable the Looting enchant on weapons to affect the Wither's drops")
    private boolean witherLooting = true;
    @Config
    private boolean netherStarLooting = true;
    @Config(minFloat=0.0f, comment="Scales the amount of reward in relation to Wither strength (non-linear)")
    private float lootingLevelMultiplier = 2.0f;
    @Config(minFloat=0.0f)
    private float netherStarLootingMultiplier = 0.5f;
    private WitherWorldData saveData = null;

    public WitherHandler() {
        HardcoreWither.CONFIG.register(this);
        HardcoreWither.CONFIG.register(WitherAffinityHelper.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PowerUpHelper.initialize();
        WitherData.register();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (this.saveData == null && !event.getWorld().field_72995_K) {
            this.saveData = WitherWorldData.loadWitherWorldSavedData(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (this.saveData != null) {
            this.saveData.func_76185_a();
            this.saveData = null;
        }
    }

    @SubscribeEvent
    public void onMobConstructing(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() != null && event.getEntity().getClass() == EntityWither.class) {
            event.addCapability(WitherData.NBT_TAG, WitherData.getWitherDataProvider((EntityWither)event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onSpawnMob(EntityJoinWorldEvent event) {
        EntityWither theWither;
        WitherData witherData;
        if (!event.getWorld().field_72995_K && event.getEntity() != null && event.getEntity().getClass() == EntityWither.class && !(witherData = WitherData.getWitherData(theWither = (EntityWither)event.getEntity())).isPoweredUp()) {
            List nearbyPlayers = theWither.field_70170_p.func_72872_a(EntityPlayer.class, theWither.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
            double powerUpSize = 0.0;
            for (EntityPlayer player : nearbyPlayers) {
                PlayerData data = PlayerData.getPlayerData(player);
                powerUpSize += data.wasAtWitherSpawn();
            }
            if (this.saveData != null) {
                if (powerUpSize > (double)this.saveData.getLargestPowerUp()) {
                    this.saveData.setLargestPowerUp((int)Math.round(powerUpSize));
                }
                if (nearbyPlayers.size() == 0) {
                    this.saveData.setLargestPowerUp(this.saveData.getLargestPowerUp() + 1);
                    powerUpSize = this.saveData.getLargestPowerUp();
                }
            } else {
                HardcoreWither.LOGGER.error("Cannot access WitherWorldData, did not load properly. Not all data may save.");
            }
            PowerUpHelper.powerUpWither(witherData, (int)Math.round(powerUpSize));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        WitherData data;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving() != null && event.getEntityLiving().getClass() == EntityWither.class && (data = WitherData.getWitherData((EntityWither)event.getEntityLiving())) != null) {
            data.update();
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack weaponStack;
        if (event.getEntity() instanceof EntityWither && event.getSource().func_76346_g() instanceof EntityPlayer && (weaponStack = (player = (EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND)) != null && HardcoreWither.API.getWitherAffinityRegistry().isRegistered(weaponStack.func_77973_b())) {
            Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)weaponStack);
            Integer witherAffinityLevel = (Integer)enchantMap.get(EnchantmentRegistry.witherAffinity);
            if (event.getEntityLiving().func_110143_aJ() <= event.getAmount()) {
                if (witherAffinityLevel == null) {
                    enchantMap.put(EnchantmentRegistry.witherAffinity, 1);
                    EnchantmentHelper.func_82782_a((Map)enchantMap, (ItemStack)weaponStack);
                }
            } else if (witherAffinityLevel != null) {
                WitherData witherData;
                WitherAffinityHelper.setWitherAffinityXp(weaponStack, WitherAffinityHelper.getWitherAffinityXp(weaponStack) + Math.round(event.getAmount()));
                if (WitherAffinityHelper.shouldWitherAffinityLevelUp(weaponStack, witherAffinityLevel)) {
                    enchantMap.put(EnchantmentRegistry.witherAffinity, witherAffinityLevel + 1);
                    EnchantmentHelper.func_82782_a((Map)enchantMap, (ItemStack)weaponStack);
                }
                if (HardcoreWither.RAND.nextFloat() < WitherAffinityHelper.chanceCalc(witherAffinityLevel) && (witherData = WitherData.getWitherData((EntityWither)event.getEntity())) != null) {
                    PowerUpHelper.reduceWitherPowerUp(witherData);
                }
            }
        }
    }

    @SubscribeEvent
    public void witherLootDrops(LivingDropsEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving() != null && event.getEntityLiving().getClass() == EntityWither.class) {
            WitherData witherData = WitherData.getWitherData((EntityWither)event.getEntityLiving());
            if (witherData != null && !witherData.isPendingLootDrops()) {
                witherData.setPendingLootDrops(true);
                int lootingLevel = (this.witherLooting ? event.getLootingLevel() : 0) + (int)Math.round(Math.log10(witherData.getStrength() + 1) * (double)this.lootingLevelMultiplier);
                if (!ForgeHooks.onLivingDrops((EntityLivingBase)event.getEntityLiving(), (DamageSource)event.getSource(), (ArrayList)((ArrayList)event.getDrops()), (int)lootingLevel, (boolean)event.isRecentlyHit())) {
                    for (EntityItem item : event.getDrops()) {
                        event.getEntityLiving().field_70170_p.func_72838_d((Entity)item);
                    }
                }
                event.setCanceled(true);
            } else if (witherData != null) {
                witherData.setPendingLootDrops(false);
                if (this.netherStarLooting && event.getLootingLevel() > 0) {
                    int j = 0;
                    if ((j = (int)((long)j + Math.round(Math.abs(HardcoreWither.RAND.nextGaussian() * (double)event.getLootingLevel() * (double)this.netherStarLootingMultiplier)))) > 0) {
                        EntityItem entityItem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(Items.field_151156_bN, j, 0));
                        entityItem.func_174867_a(10);
                        event.getDrops().add(entityItem);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDieing(LivingDeathEvent event) {
        WitherData witherData;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving() != null && event.getEntityLiving().getClass() == EntityWither.class && (witherData = WitherData.getWitherData((EntityWither)event.getEntityLiving())) != null) {
            witherData.died();
            List nearbyPlayers = event.getEntity().field_70170_p.func_72872_a(EntityPlayer.class, event.getEntity().func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayer player : nearbyPlayers) {
                PlayerData data = PlayerData.getPlayerData(player);
                data.wasAtWitherSpawn();
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.localize("info.hardcorewither.chat.wither-experience")));
            }
        }
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        int witherAffinityLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.witherAffinity, (ItemStack)event.getItemStack());
        if (witherAffinityLevel > 0) {
            int witherAffinityXp = WitherAffinityHelper.getWitherAffinityXp(event.getItemStack());
            String witherAffinityLine = I18n.localize("tooltip.hardcorewither.witherAffinity") + ": " + witherAffinityXp + "/" + WitherAffinityHelper.xpCalc(witherAffinityLevel);
            event.getToolTip().add(witherAffinityLine);
            event.getToolTip().add("");
        }
    }
}

