/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.api.IPowerUp;
import thor12022.hardcorewither.api.IPowerUpEffect;

public class WitherData {
    static final ResourceLocation NBT_TAG = new ResourceLocation("witherData");
    private static final String NBT_EFFECT_NAME_TAG = "name";
    private static final String NBT_EFFECT_TAG = "effect";
    @CapabilityInject(value=WitherData.class)
    public static Capability<WitherData> CAPABILITY;
    private final Set<IPowerUpEffect> activePowerUps = new HashSet<IPowerUpEffect>();
    private boolean hasDied = false;
    private boolean isPendingLootDrops = false;
    private boolean isPoweredUp = false;
    private final EntityWither ownerWither;

    static void register() {
        CapabilityManager.INSTANCE.register(WitherData.class, (Capability.IStorage)new Capability.IStorage<WitherData>(){

            public NBTBase writeNBT(Capability<WitherData> capability, WitherData instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<WitherData> capability, WitherData instance, EnumFacing side, NBTBase base) {
            }
        }, (Callable)new Callable<WitherData>(){

            @Override
            public WitherData call() throws Exception {
                return new WitherData(null);
            }
        });
    }

    static ICapabilitySerializable<NBTTagCompound> getWitherDataProvider(final EntityWither Wither) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            WitherData cap;
            {
                this.cap = new WitherData(Wither);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                if (capability == CAPABILITY) {
                    return (T)CAPABILITY.cast((Object)this.cap);
                }
                return null;
            }

            public NBTTagCompound serializeNBT() {
                return this.cap.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                this.cap.deserializeNBT(nbt);
            }
        };
    }

    public static WitherData getWitherData(EntityWither wither) {
        if (wither.hasCapability(CAPABILITY, null)) {
            return (WitherData)wither.getCapability(CAPABILITY, null);
        }
        return null;
    }

    WitherData(EntityWither wither) {
        this.ownerWither = wither;
    }

    int getActivePowerUpEffectsNum() {
        return this.activePowerUps.size();
    }

    IPowerUpEffect getRandomActivePowerUpEffect() {
        return (IPowerUpEffect)this.activePowerUps.toArray()[HardcoreWither.RAND.nextInt(this.activePowerUps.size())];
    }

    IPowerUpEffect getActivePowerUpEffect(IPowerUp powerUp) {
        for (IPowerUpEffect effect : this.activePowerUps) {
            if (effect.getCreator() != powerUp) continue;
            return effect;
        }
        return null;
    }

    boolean addPowerUpEffect(@Nonnull IPowerUp powerUp, int powerUpStrength) {
        IPowerUpEffect powerUpEffect;
        if (this.getActivePowerUpEffect(powerUp) == null && (powerUpEffect = powerUp.getPowerUpEffect(this.ownerWither, powerUpStrength)) != null) {
            this.activePowerUps.add(powerUpEffect);
            return true;
        }
        return false;
    }

    boolean removePowerUpEffect(IPowerUpEffect powerUpEffect) {
        return this.activePowerUps.remove(powerUpEffect);
    }

    void removeAllPowerUpEffects() {
        this.activePowerUps.clear();
    }

    boolean isPendingLootDrops() {
        return this.isPendingLootDrops;
    }

    void setPendingLootDrops(boolean isPendingLootDrops) {
        this.isPendingLootDrops = isPendingLootDrops;
    }

    int getStrength() {
        AtomicInteger strength = new AtomicInteger(0);
        this.activePowerUps.forEach(effect -> strength.getAndAdd(effect.getStrength()));
        return strength.get();
    }

    public boolean isPoweredUp() {
        return this.isPoweredUp;
    }

    public void setPoweredUp(boolean isPoweredUp) {
        this.isPoweredUp = isPoweredUp;
    }

    public EntityWither getWither() {
        return this.ownerWither;
    }

    void update() {
        for (IPowerUpEffect powerUp : this.activePowerUps) {
            try {
                powerUp.updateEffect();
            }
            catch (Exception e) {
                HardcoreWither.LOGGER.error((Object)e);
                HardcoreWither.LOGGER.error("Error Occured while updating PowerUp " + powerUp.getCreator().getRegistryName() + ", removing.");
                this.activePowerUps.remove(powerUp);
                break;
            }
        }
    }

    void died() {
        for (IPowerUpEffect powerUp : this.activePowerUps) {
            powerUp.onDied();
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound witherDataTag = new NBTTagCompound();
        NBTTagList powerUpEffectsTagList = new NBTTagList();
        for (IPowerUpEffect effect : this.activePowerUps) {
            NBTTagCompound effectTag = new NBTTagCompound();
            effectTag.func_74778_a(NBT_EFFECT_NAME_TAG, effect.getCreator().getRegistryName().toString());
            effectTag.func_74782_a(NBT_EFFECT_TAG, effect.serializeNBT());
            powerUpEffectsTagList.func_74742_a((NBTBase)effectTag);
        }
        witherDataTag.func_74782_a("powerUpEffectsList", (NBTBase)powerUpEffectsTagList);
        witherDataTag.func_74757_a("isPoweredUp", this.isPoweredUp);
        witherDataTag.func_74757_a("hasDied", this.hasDied);
        witherDataTag.func_74757_a("isPendingLootDrops", this.isPendingLootDrops);
        return witherDataTag;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        NBTTagList powerUpEffectsTagList = compound.func_150295_c("powerUpEffectsList", (int)new NBTTagCompound().func_74732_a());
        this.isPoweredUp = compound.func_74767_n("isPoweredUp");
        this.hasDied = compound.func_74767_n("hasDied");
        this.isPendingLootDrops = compound.func_74767_n("isPendingLootDrops");
        for (int i = 0; i < powerUpEffectsTagList.func_74745_c(); ++i) {
            try {
                NBTTagCompound powerUpEffectTag = powerUpEffectsTagList.func_150305_b(i);
                IPowerUp powerUp = (IPowerUp)HardcoreWither.API.getPowerUpRegistry().getValue(new ResourceLocation(powerUpEffectTag.func_74779_i(NBT_EFFECT_NAME_TAG)));
                IPowerUpEffect effect = powerUp.restorePowerUp(this.ownerWither, powerUpEffectTag.func_74775_l(NBT_EFFECT_TAG));
                this.activePowerUps.add(effect);
                continue;
            }
            catch (NullPointerException e) {
                HardcoreWither.LOGGER.warn((Object)e);
                HardcoreWither.LOGGER.warn("Problem loading " + powerUpEffectsTagList.func_150305_b(i).func_74732_a() + " NBT for EntityWither, " + this.ownerWither.func_110124_au());
            }
        }
    }
}

