/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;

@Configurable(sectionName="WitherAffinity")
class WitherAffinityHelper {
    private static final String NBT_WITHER_AFFINITY = "witherAffinity";
    @Config
    private static boolean isEnabled = true;
    @Config(minInt=1)
    private static int levelingBase = 300;
    @Config(minFloat=1.0f)
    private static float levelingMultiplier = 2.5f;
    @Config(comment="is s, the enchant level is l, and the chance is c: where s/(-1*l-s) = c")
    private static float powerUpRemovalChanceScale = 12.0f;

    WitherAffinityHelper() {
    }

    static int getWitherAffinityXp(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("hardcorewither", true);
        return tag.func_74762_e(NBT_WITHER_AFFINITY);
    }

    static void setWitherAffinityXp(ItemStack stack, int xp) {
        NBTTagCompound tag = stack.func_179543_a("hardcorewither", true);
        tag.func_74768_a(NBT_WITHER_AFFINITY, xp);
    }

    static float chanceCalc(int currentLevel) {
        return powerUpRemovalChanceScale / ((float)(-1 * currentLevel) - powerUpRemovalChanceScale);
    }

    static int xpCalc(int currentLevel) {
        return currentLevel * (levelingBase + (int)((float)(levelingBase - 1) * levelingMultiplier));
    }

    static boolean shouldWitherAffinityLevelUp(ItemStack stack, int currentLevel) {
        return WitherAffinityHelper.getWitherAffinityXp(stack) >= WitherAffinityHelper.xpCalc(currentLevel);
    }
}

