/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.wither;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.api.IPowerUp;
import thor12022.hardcorewither.api.IPowerUpEffect;
import thor12022.hardcorewither.wither.WitherData;
import thor12022.hardcorewither.wither.powerups.PowerUpBlazeMinionSpawner;
import thor12022.hardcorewither.wither.powerups.PowerUpDamageResistance;
import thor12022.hardcorewither.wither.powerups.PowerUpDeathKnell;
import thor12022.hardcorewither.wither.powerups.PowerUpGhastMinionSpawner;
import thor12022.hardcorewither.wither.powerups.PowerUpHealthBoost;
import thor12022.hardcorewither.wither.powerups.PowerUpLightning;
import thor12022.hardcorewither.wither.powerups.PowerUpSkeletonMinionSpawner;
import thor12022.hardcorewither.wither.powerups.PowerUpTeleport;

class PowerUpHelper {
    static CommandBase spawnCommand = new CommandBase(){

        public final String func_71518_a(ICommandSender sender) {
            return "commands." + this.func_71517_b() + ".usage";
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
            ArrayList<String> powerUps = new ArrayList<String>();
            for (ResourceLocation powerUp : HardcoreWither.API.getPowerUpRegistry().func_148742_b()) {
                powerUps.add(powerUp.toString());
            }
            return powerUps;
        }

        public final String func_71517_b() {
            return "spawn";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
            if (args.length < 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            EntityWither spawnedWither = new EntityWither(sender.func_130014_f_());
            BlockPos coords = sender.func_180425_c();
            spawnedWither.func_70107_b((double)coords.func_177958_n(), (double)coords.func_177956_o(), (double)coords.func_177952_p());
            spawnedWither.func_82206_m();
            sender.func_130014_f_().func_72838_d((Entity)spawnedWither);
            try {
                WitherData witherData = WitherData.getWitherData(spawnedWither);
                if (witherData != null) {
                    witherData.removeAllPowerUpEffects();
                    for (String arg : args) {
                        String[] splitArg = arg.split(",");
                        String powerUpName = splitArg[0];
                        int powerUpStrength = splitArg.length > 1 ? 1.func_180528_a((String)splitArg[1], (int)1) : 1;
                        IPowerUp powerUp = (IPowerUp)HardcoreWither.API.getPowerUpRegistry().getValue(new ResourceLocation(powerUpName));
                        if (powerUp == null) {
                            HardcoreWither.LOGGER.debug("PowerUp: " + powerUpName + "not valid");
                            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                        }
                        witherData.addPowerUpEffect(powerUp, powerUpStrength);
                    }
                }
            }
            catch (Exception excp) {
                spawnedWither.field_70170_p.func_72900_e((Entity)spawnedWither);
                HardcoreWither.LOGGER.debug("PowerUp Command Formatting Error (probably) not accounted for " + excp);
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }

        public int func_82362_a() {
            return 2;
        }
    };

    PowerUpHelper() {
    }

    static void initialize() {
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpBlazeMinionSpawner());
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpDeathKnell());
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpGhastMinionSpawner());
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpHealthBoost());
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpSkeletonMinionSpawner());
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpLightning());
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpTeleport());
        HardcoreWither.API.getPowerUpRegistry().register((IForgeRegistryEntry)new PowerUpDamageResistance());
        HardcoreWither.COMMAND.addSubcommand((ICommand)spawnCommand);
    }

    static void powerUpWither(WitherData witherData, int sizeOfPowerUp) {
        if (witherData.getActivePowerUpEffectsNum() == 0) {
            int usedStrength = 0;
            List validPowerUps = HardcoreWither.API.getPowerUpRegistry().getValues();
            validPowerUps.removeIf(powerUp -> powerUp.minWitherLevel() > sizeOfPowerUp);
            validPowerUps.removeIf(powerUp -> powerUp.canApply(witherData.getWither()));
            while (usedStrength < sizeOfPowerUp && validPowerUps.size() > 0) {
                int powerUpIndex = HardcoreWither.RAND.nextInt(validPowerUps.size());
                IPowerUp powerUp2 = (IPowerUp)validPowerUps.get(powerUpIndex);
                IPowerUpEffect powerUpEffect = witherData.getActivePowerUpEffect(powerUp2);
                if (powerUpEffect != null) {
                    int currentStength = powerUpEffect.getStrength();
                    if (currentStength < powerUp2.maxStrength()) {
                        powerUpEffect.setStrength(currentStength + 1);
                        ++usedStrength;
                        HardcoreWither.LOGGER.debug("Increasing power of " + powerUp2.getClass());
                        continue;
                    }
                    validPowerUps.remove(powerUpIndex);
                    continue;
                }
                witherData.addPowerUpEffect(powerUp2, 1);
                usedStrength += powerUp2.minWitherLevel() > 0 ? powerUp2.minWitherLevel() : 1;
                HardcoreWither.LOGGER.debug("Adding " + powerUp2.getRegistryName());
            }
        } else {
            HardcoreWither.LOGGER.debug("Attempting to re-powerup Wither");
        }
        witherData.setPoweredUp(true);
    }

    public static void reduceWitherPowerUp(WitherData witherData) {
        IPowerUpEffect powerUpEffect = witherData.getRandomActivePowerUpEffect();
        int currentStrength = powerUpEffect.getStrength();
        if (currentStrength == 1) {
            witherData.removePowerUpEffect(powerUpEffect);
        } else {
            powerUpEffect.setStrength(currentStrength - 1);
        }
    }
}

