/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.potions;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thor12022.hardcorewither.HardcoreWither;

public class PotionAntiWither
extends Potion {
    public static final String NAME = "antiWither";
    private static final Map<EntityLivingBase, Integer> AFFECTED_ENTITIES = Maps.newHashMap();
    private static final Set<EntityLivingBase> AFFECTED_WITHERED_ENTITIES = Sets.newHashSet();

    public PotionAntiWither() {
        super(false, 0x140014);
        this.func_76390_b("potion.hardcorewither.antiWither");
        this.setRegistryName(NAME);
        this.func_76399_b(1, 0);
    }

    public static boolean HasEntityBeenWithered(EntityLivingBase entity) {
        return AFFECTED_WITHERED_ENTITIES.contains(entity);
    }

    public void func_111185_a(EntityLivingBase entityLiving, AbstractAttributeMap map, int par3) {
        if (!AFFECTED_ENTITIES.containsKey(entityLiving)) {
            AFFECTED_ENTITIES.put(entityLiving, -1);
        }
    }

    public void func_111187_a(EntityLivingBase entityLiving, AbstractAttributeMap map, int par3) {
        if (AFFECTED_ENTITIES.containsKey(entityLiving)) {
            AFFECTED_ENTITIES.remove(entityLiving);
        }
        if (AFFECTED_WITHERED_ENTITIES.contains(entityLiving)) {
            AFFECTED_WITHERED_ENTITIES.remove(entityLiving);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("hardcorewither:textures/guis/icons.png"));
        return 1;
    }

    public boolean func_76397_a(int tick, int amplifier) {
        return true;
    }

    public void func_76394_a(EntityLivingBase entityLivingBaseIn, int p_76394_2_) {
        PotionEffect witherEffect = entityLivingBaseIn.func_70660_b(MobEffects.field_82731_v);
        if (witherEffect != null) {
            if (witherEffect.func_76459_b() > AFFECTED_ENTITIES.get(entityLivingBaseIn)) {
                int newDuration = (witherEffect.func_76459_b() - AFFECTED_ENTITIES.get(entityLivingBaseIn)) / (2 * (p_76394_2_ + 1));
                HardcoreWither.LOGGER.debug("Anti-Wither reducing Wither effect to " + newDuration / 20 + " seconds for " + entityLivingBaseIn.func_145748_c_());
                int amplifier = witherEffect.func_76458_c();
                entityLivingBaseIn.func_184589_d(MobEffects.field_82731_v);
                entityLivingBaseIn.func_70690_d(new PotionEffect(MobEffects.field_82731_v, newDuration, amplifier));
                AFFECTED_ENTITIES.put(entityLivingBaseIn, newDuration);
                AFFECTED_WITHERED_ENTITIES.add(entityLivingBaseIn);
            } else {
                AFFECTED_ENTITIES.put(entityLivingBaseIn, witherEffect.func_76459_b());
            }
        }
    }

    public void func_180793_a(Entity source, Entity indirectSource, EntityLivingBase entityLivingBaseIn, int amplifier, double health) {
    }
}

