/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.items;

import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.items.IItem;
import thor12022.hardcorewither.items.ItemCrafting;
import thor12022.hardcorewither.items.ItemDeathStick;
import thor12022.hardcorewither.items.ItemStarryApple;
import thor12022.hardcorewither.items.ItemStarryAxe;
import thor12022.hardcorewither.items.ItemStarryPickaxe;
import thor12022.hardcorewither.items.ItemStarryShovel;
import thor12022.hardcorewither.items.ItemStarrySword;

public class ItemRegistry {
    public static Item starryApple = new ItemStarryApple();
    public static Item starryAxe = new ItemStarryAxe();
    public static Item starryPickaxe = new ItemStarryPickaxe();
    public static Item starryShovel = new ItemStarryShovel();
    public static Item starrySword = new ItemStarrySword();
    public static Item craftingItem = new ItemCrafting();
    public static Item deathStick = new ItemDeathStick();
    private ArrayList<IItem> items = new ArrayList();

    public ItemRegistry() {
        for (Field field : this.getClass().getFields()) {
            if (field.getType() != Item.class) continue;
            try {
                this.items.add((IItem)field.get(null));
            }
            catch (Exception e) {
                HardcoreWither.LOGGER.error((Object)e);
                HardcoreWither.LOGGER.fatal("Item not properly defined in registry: " + field.getName());
            }
        }
    }

    public void registerItems() {
        for (IItem item : this.items) {
            if (!item.isEnabled()) continue;
            item.registerItem();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (IItem item : this.items) {
            if (!item.isEnabled()) continue;
            item.registerModel();
        }
    }

    public void registerRecipes() {
        for (IItem item : this.items) {
            if (!item.isEnabled()) continue;
            item.registerRecipe();
        }
    }
}

