/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.config;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;

public class ConfigManager {
    private ArrayList<Object> configObjects = new ArrayList();
    private ArrayList<Class<?>> configClasses = new ArrayList();
    private Configuration configuration;

    public ConfigManager(String modName) {
        File config = new File(Loader.instance().getConfigDir().getAbsolutePath() + File.separatorChar + modName + ".cfg");
        this.configuration = new Configuration(config);
    }

    public void register(Object target) {
        if (target instanceof Class) {
            Configurable annotation = ((Class)target).getAnnotation(Configurable.class);
            if (annotation != null) {
                try {
                    Class.forName(((Class)target).getName());
                    this.configClasses.add((Class)target);
                    this.processConfigClass((Class)target);
                    this.configuration.save();
                }
                catch (ClassNotFoundException e) {
                    HardcoreWither.LOGGER.error((Object)e);
                }
            }
        } else {
            Configurable annotation = target.getClass().getAnnotation(Configurable.class);
            if (annotation != null) {
                this.configObjects.add(target);
                this.processConfigObject(target);
                this.configuration.save();
            }
        }
    }

    public void syncConfig() {
        if (this.configuration != null) {
            for (Object object : this.configObjects) {
                this.processConfigObject(object);
            }
            for (Class clazz : this.configClasses) {
                this.processConfigClass(clazz);
            }
            this.configuration.save();
            for (Object object : this.configObjects) {
                ConfigManager.processNotificationClass(object);
            }
        }
    }

    public File getConfigFile() {
        return this.configuration.getConfigFile();
    }

    private void processConfigObject(Object target) {
        try {
            Configurable targetAnnotation = target.getClass().getAnnotation(Configurable.class);
            String sectionName = targetAnnotation.sectionName();
            if (sectionName.isEmpty()) {
                sectionName = target.getClass().getSimpleName();
            }
            this.processClass(sectionName, target, target.getClass());
        }
        catch (Exception e) {
            HardcoreWither.LOGGER.warn((Object)e);
            HardcoreWither.LOGGER.warn("Cannot find @Configurable Annotation on " + target.getClass().getName());
        }
    }

    private void processConfigClass(Class<?> target) {
        try {
            Configurable targetAnnotation = target.getAnnotation(Configurable.class);
            String sectionName = targetAnnotation.sectionName();
            if (sectionName.isEmpty()) {
                sectionName = target.getSimpleName();
            }
            this.processClass(sectionName, null, target);
        }
        catch (Exception e) {
            HardcoreWither.LOGGER.warn((Object)e);
            HardcoreWither.LOGGER.warn("Cannot find @Configurable Annotation on " + target.getName());
        }
    }

    private static void processNotificationClass(Object target) {
        Configurable targetAnnotation = target.getClass().getAnnotation(Configurable.class);
        String callbackName = targetAnnotation.syncNotification();
        if (!callbackName.isEmpty()) {
            try {
                Method method = target.getClass().getDeclaredMethod(callbackName, new Class[0]);
                method.invoke(target, new Object[0]);
            }
            catch (Exception excp) {
                HardcoreWither.LOGGER.debug((Object)excp);
                HardcoreWither.LOGGER.warn("Invalid Config callback method: " + target.getClass().getName() + "." + callbackName);
            }
        }
    }

    private void processClass(String sectionName, Object classObj, Class<?> currentClass) {
        if (currentClass == null || currentClass == Object.class) {
            return;
        }
        this.processClass(sectionName, classObj, currentClass.getSuperclass());
        for (Field field : currentClass.getDeclaredFields()) {
            Config configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            String fieldName = configAnnotation.fieldName();
            if (fieldName.isEmpty()) {
                fieldName = field.getName();
            }
            try {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.getType() == Boolean.TYPE) {
                    field.set(classObj, this.configuration.getBoolean(fieldName, sectionName, field.getBoolean(classObj), configAnnotation.comment()));
                } else if (field.getType() == Float.TYPE) {
                    field.set(classObj, Float.valueOf(this.configuration.getFloat(fieldName, sectionName, field.getFloat(classObj), configAnnotation.minFloat(), configAnnotation.maxFloat(), configAnnotation.comment())));
                } else if (field.getType() == Integer.TYPE) {
                    field.set(classObj, this.configuration.getInt(fieldName, sectionName, field.getInt(classObj), configAnnotation.minInt(), configAnnotation.maxInt(), configAnnotation.comment()));
                } else if (field.getType() == String.class) {
                    field.set(classObj, this.configuration.getString(fieldName, sectionName, (String)field.get(classObj), configAnnotation.comment()));
                } else {
                    this.processClass(sectionName, field.get(classObj), field.getType());
                }
                field.setAccessible(isAccessible);
            }
            catch (IllegalAccessException excp) {
                HardcoreWither.LOGGER.warn((Object)excp);
                String extraError = classObj == null ? "Possibly nonstatic field used with static Class Registration" : "";
                HardcoreWither.LOGGER.warn("Problem getting configurable field \"" + currentClass.getName() + "." + field.getName() + "\"." + extraError);
            }
        }
    }
}

