/*
 * Decompiled with CFR 0.152.
 */
package thor12022.hardcorewither.compatability;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thor12022.hardcorewither.HardcoreWither;
import thor12022.hardcorewither.config.Config;
import thor12022.hardcorewither.config.Configurable;
import thor12022.hardcorewither.items.ItemStarryApple;
import thor12022.hardcorewither.potions.PotionAntiWither;
import thor12022.hardcorewither.potions.PotionRegistry;
import thor12022.hardcorewither.util.I18n;

@Configurable(sectionName="TinkersConstruct")
public class TinkersConstructHandler {
    @Config
    private static boolean enableGreenHeartCanister = true;
    @Config
    private static boolean enableGreenHeartWitherDrop = true;
    @Config(minInt=0, maxInt=10)
    private static int greenHeartDropRarity = 2;
    private static Item heartCanister = null;

    public TinkersConstructHandler() {
        HardcoreWither.CONFIG.register(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init() {
        HardcoreWither.LOGGER.info("Tinkers' Constuct Support Initalizing");
        if (enableGreenHeartCanister) {
            if (heartCanister == null) {
                heartCanister = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("tconstruct:heartCanister"));
            }
            if (heartCanister != null) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(heartCanister, 1, 6), (Object[])new Object[]{new ItemStack(heartCanister, 1, 4), new ItemStack(heartCanister, 1, 5), new ItemStack(Items.field_151156_bN)});
            } else {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                HardcoreWither.LOGGER.warn("Cannot find TConstruct:heartCanister, disabling Tinkers' Construct support");
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        EntityPlayer killerPlayer;
        PotionEffect antiWitherEffect;
        if (!enableGreenHeartWitherDrop || !event.isRecentlyHit()) {
            return;
        }
        if (event.getEntityLiving() != null && event.getEntityLiving().getClass() == EntityWither.class && event.getSource().field_76373_n.equals("player") && (antiWitherEffect = (killerPlayer = (EntityPlayer)event.getSource().func_76346_g()).func_70660_b(PotionRegistry.potionAntiWither)) != null && PotionAntiWither.HasEntityBeenWithered((EntityLivingBase)killerPlayer)) {
            int numberOfHearts = 0;
            for (int lootingLevel = event.getLootingLevel(); lootingLevel > 0; --lootingLevel) {
                numberOfHearts += HardcoreWither.RAND.nextInt(greenHeartDropRarity) == 0 ? 1 : 0;
            }
            EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(heartCanister, numberOfHearts, 5));
            entityitem.func_174867_a(10);
            event.getDrops().add(entityitem);
            HardcoreWither.LOGGER.debug("Withered Anti-Withered Player killed Wither, dropping Miniture" + numberOfHearts + " Green Hearts");
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (enableGreenHeartWitherDrop && heartCanister != null && event.getItemStack().func_77973_b() instanceof ItemStarryApple) {
            event.getToolTip().add(TextFormatting.GREEN.toString() + TextFormatting.ITALIC + I18n.localize("tooltip.hardcorewither.starryApple"));
        }
    }
}

