/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.config.Settings;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BlockUtils {
    private static final Set<IBlockState> loggedWarningFor = Collections.synchronizedSet(new HashSet());

    @Nullable
    public static ItemStack getItemStackFromState(IBlockState state, @Nullable World world) {
        Block block = state.func_177230_c();
        try {
            return block.getPickBlock(state, null, world, BlockPos.field_177992_a, null);
        }
        catch (Throwable t) {
            try {
                Item item = Item.func_150898_a((Block)block);
                int damage = block.func_180651_a(state);
                ItemStack stack = new ItemStack(item, 1, damage);
                int meta = item.getMetadata(stack);
                if (Objects.equals(block.func_176203_a(meta), state)) {
                    return stack;
                }
                throw new Exception("Block/Item implementation does not allow round-trip via Block.damageDropped/Item.getMetadata/Block.getStateFromMeta: " + block.toString() + ", " + item.toString());
            }
            catch (Throwable t2) {
                if (Settings.logBlockDropLookupFailures && loggedWarningFor.add(state)) {
                    Scannable.getLog().debug("Failed determining dropped block for " + state.toString() + " via getPickBlock, trying to resolve via meta.", t);
                    Scannable.getLog().debug("Failed determining dropped block for " + state.toString() + " via meta.", t2);
                }
                return null;
            }
        }
    }

    private BlockUtils() {
    }
}

