/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.integration.optifine;

import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import li.cil.scannable.common.Scannable;

public enum ProxyOptiFine {
    INSTANCE;

    private IntSupplier getDepthTexture;
    private BooleanSupplier isShaderPackLoaded;

    private ProxyOptiFine() {
        try {
            Class<?> clazz = Class.forName("shadersmod.client.Shaders");
            Field depthTexturesField = clazz.getDeclaredField("dfbDepthTextures");
            depthTexturesField.setAccessible(true);
            IntBuffer depthTextures = (IntBuffer)depthTexturesField.get(null);
            this.getDepthTexture = () -> depthTextures.get(0);
            Field field = clazz.getDeclaredField("shaderPackLoaded");
            field.setAccessible(true);
            this.isShaderPackLoaded = () -> {
                try {
                    return field.getBoolean(null);
                }
                catch (IllegalAccessException e) {
                    Scannable.getLog().warn("Failed reading field indicating whether shaders are enabled. Shader mod integration disabled.");
                    this.getDepthTexture = null;
                    this.isShaderPackLoaded = null;
                    return false;
                }
            };
            Scannable.getLog().info("Successfully integrated with shader mod.");
        }
        catch (ClassNotFoundException e) {
            Scannable.getLog().info("No shader mod found, we'll do our own hacks to inject a depth texture when needed.");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Scannable.getLog().warn("Failed integrating with shader mod. Ignoring.");
        }
    }

    public boolean isShaderPackLoaded() {
        return this.isShaderPackLoaded != null && this.isShaderPackLoaded.getAsBoolean();
    }

    public int getDepthTexture() {
        return this.getDepthTexture != null ? this.getDepthTexture.getAsInt() : 0;
    }
}

