/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.init.Items;
import li.cil.scannable.common.item.AbstractItemScannerModuleEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public final class ItemScannerModuleEntity
extends AbstractItemScannerModuleEntity {
    private static final String TAG_ENTITY = "entity";

    @Nullable
    public static String getEntity(ItemStack stack) {
        if (!Items.isModuleEntity(stack)) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b(TAG_ENTITY, 8)) {
            return null;
        }
        return nbt.func_74779_i(TAG_ENTITY);
    }

    private static void setEntity(ItemStack stack, String entity) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        } else {
            nbt = stack.func_77978_p();
        }
        assert (nbt != null);
        nbt.func_74778_a(TAG_ENTITY, entity);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        String entity = ItemScannerModuleEntity.getEntity(stack);
        if (entity == null) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_entity", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_entity.name", (Object[])new Object[]{entity}));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!slotChanged && Items.isModuleEntity(oldStack) && Items.isModuleEntity(newStack)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!(target instanceof EntityLiving)) {
            return false;
        }
        String entity = EntityList.func_75621_b((Entity)target);
        if (entity == null) {
            return false;
        }
        ItemScannerModuleEntity.setEntity(player.func_184586_b(hand), entity);
        player.func_184609_a(hand);
        player.field_71071_by.func_70296_d();
        return true;
    }
}

