/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.inventory;

import java.util.Arrays;
import javax.annotation.Nonnull;
import li.cil.scannable.common.capabilities.CapabilityScanResultProvider;
import li.cil.scannable.common.item.AbstractItemScannerModule;
import li.cil.scannable.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public final class ItemHandlerScanner
extends ItemStackHandler {
    private static final String TAG_ITEMS = "items";
    private final ItemStack container;

    public ItemHandlerScanner(ItemStack container) {
        super(9);
        this.container = container;
    }

    public void updateFromNBT() {
        NBTTagCompound nbt = this.container.func_77978_p();
        if (nbt != null && nbt.func_150297_b(TAG_ITEMS, 10)) {
            this.deserializeNBT((NBTTagCompound)nbt.func_74781_a(TAG_ITEMS));
            if (this.stacks.length != 9) {
                ItemStack[] oldStacks = Arrays.copyOf(this.stacks, this.stacks.length);
                this.setSize(9);
                int count = Math.min(9, oldStacks.length);
                System.arraycopy(oldStacks, 0, this.stacks, 0, count);
            }
        }
    }

    public IItemHandler getActiveModules() {
        return new RangedWrapper((IItemHandlerModifiable)this, 0, 3);
    }

    public IItemHandler getInactiveModules() {
        return new RangedWrapper((IItemHandlerModifiable)this, 3, 9);
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return 0;
        }
        if (stack.func_77973_b() instanceof AbstractItemScannerModule) {
            return 64;
        }
        if (stack.hasCapability(CapabilityScanResultProvider.SCAN_RESULT_PROVIDER_CAPABILITY, null)) {
            return 64;
        }
        return 0;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.container.func_77983_a(TAG_ITEMS, (NBTBase)this.serializeNBT());
    }
}

