/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.renderer.ScannerRenderer;
import li.cil.scannable.common.capabilities.CapabilityScanResultProvider;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.init.Items;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ScanManager {
    INSTANCE;

    private final Set<ScanResultProvider> collectingProviders = new HashSet<ScanResultProvider>();
    private final Map<ScanResultProvider, List<ScanResult>> collectingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private final Map<ScanResultProvider, List<ScanResult>> pendingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private final Map<ScanResultProvider, List<ScanResult>> renderingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private final List<ScanResult> renderingList = new ArrayList<ScanResult>();
    private int scanningTicks = -1;
    private long currentStart = -1L;
    @Nullable
    private Vec3d lastScanCenter;

    private static int computeTargetRadius() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 - 10;
    }

    public static int computeScanGrowthDuration() {
        return 2000 * Minecraft.func_71410_x().field_71474_y.field_151451_c / 12;
    }

    public static float computeRadius(long start, float duration) {
        float r1 = ScanManager.computeTargetRadius();
        float t1 = duration;
        float b = 200.0f;
        float n = 1.0f / ((t1 + 200.0f) * (t1 + 200.0f) - 40000.0f);
        float a = -r1 * 200.0f * 200.0f * n;
        float c = r1 * n;
        float t = System.currentTimeMillis() - start;
        return 10.0f + a + (t + 200.0f) * (t + 200.0f) * c;
    }

    public void beginScan(EntityPlayer player, List<ItemStack> modules) {
        this.cancelScan();
        float scanRadius = Settings.getBaseScanRadius();
        for (ItemStack module : modules) {
            ScanResultProvider provider = (ScanResultProvider)module.getCapability(CapabilityScanResultProvider.SCAN_RESULT_PROVIDER_CAPABILITY, null);
            if (provider != null) {
                this.collectingProviders.add(provider);
            }
            if (!Items.isModuleRange(module)) continue;
            scanRadius += (float)MathHelper.func_76123_f((float)((float)Settings.getBaseScanRadius() / 2.0f));
        }
        if (this.collectingProviders.isEmpty()) {
            return;
        }
        Vec3d center = player.func_174791_d();
        for (ScanResultProvider provider : this.collectingProviders) {
            provider.initialize(player, modules, center, scanRadius, 40);
        }
    }

    public void updateScan(Entity entity, boolean finish) {
        int remaining = 40 - this.scanningTicks;
        if (!finish) {
            if (remaining <= 0) {
                return;
            }
            for (ScanResultProvider scanResultProvider : this.collectingProviders) {
                scanResultProvider.computeScanResults(result -> this.collectingResults.computeIfAbsent(provider, p -> new ArrayList()).add(result));
            }
            ++this.scanningTicks;
            return;
        }
        for (int i = 0; i < remaining; ++i) {
            for (ScanResultProvider provider : this.collectingProviders) {
                provider.computeScanResults(result -> this.collectingResults.computeIfAbsent(provider, p -> new ArrayList()).add(result));
            }
        }
        for (ScanResultProvider scanResultProvider : this.collectingProviders) {
            scanResultProvider.reset();
        }
        this.clear();
        this.lastScanCenter = entity.func_174791_d();
        this.currentStart = System.currentTimeMillis();
        this.pendingResults.putAll(this.collectingResults);
        this.pendingResults.values().forEach(list -> list.sort(Comparator.comparing(result -> -this.lastScanCenter.func_72438_d(result.getPosition()))));
        ScannerRenderer.INSTANCE.ping(this.lastScanCenter);
        this.cancelScan();
    }

    public void cancelScan() {
        this.collectingProviders.clear();
        this.collectingResults.clear();
        this.scanningTicks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.lastScanCenter == null || this.currentStart < 0L) {
            return;
        }
        if (10000 < (int)(System.currentTimeMillis() - this.currentStart)) {
            this.pendingResults.clear();
            Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
            synchronized (map) {
                if (!this.renderingResults.isEmpty()) {
                    Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = this.renderingResults.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
                        List<ScanResult> list = entry.getValue();
                        for (int i = MathHelper.func_76123_f((float)((float)list.size() / 2.0f)); i > 0; --i) {
                            list.remove(list.size() - 1);
                        }
                        if (!list.isEmpty()) continue;
                        iterator.remove();
                    }
                }
                if (this.renderingResults.isEmpty()) {
                    this.clear();
                }
            }
            return;
        }
        if (this.pendingResults.size() <= 0) {
            return;
        }
        float radius = ScanManager.computeRadius(this.currentStart, ScanManager.computeScanGrowthDuration());
        float sqRadius = radius * radius;
        Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = this.pendingResults.entrySet().iterator();
        while (iterator.hasNext()) {
            ScanResult result;
            Vec3d position;
            Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
            ScanResultProvider provider = entry.getKey();
            List<ScanResult> results = entry.getValue();
            while (results.size() > 0 && this.lastScanCenter.func_72436_e(position = (result = results.get(results.size() - 1)).getPosition()) <= (double)sqRadius) {
                results.remove(results.size() - 1);
                if (!provider.isValid(result)) continue;
                Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
                synchronized (map) {
                    this.renderingResults.computeIfAbsent(provider, p -> new ArrayList()).add(result);
                }
            }
            if (results.size() != 0) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity == null) {
            return;
        }
        Frustum frustum = new Frustum();
        double posX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)event.getPartialTicks();
        double posY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)event.getPartialTicks();
        double posZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)event.getPartialTicks();
        frustum.func_78547_a(posX, posY, posZ);
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
        synchronized (map) {
            for (Map.Entry<ScanResultProvider, List<ScanResult>> entry : this.renderingResults.entrySet()) {
                for (ScanResult result : entry.getValue()) {
                    AxisAlignedBB bounds = result.getRenderBounds();
                    if (bounds != null && !frustum.func_78546_a(bounds)) continue;
                    this.renderingList.add(result);
                }
                if (this.renderingList.isEmpty()) continue;
                entry.getKey().render(entity, this.renderingList, event.getPartialTicks());
                this.renderingList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        this.pendingResults.clear();
        Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
        synchronized (map) {
            this.renderingResults.forEach((provider, results) -> provider.reset());
            this.renderingResults.clear();
        }
        this.lastScanCenter = null;
        this.currentStart = -1L;
    }
}

