/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.api.prefab;

import com.google.common.base.Strings;
import java.util.Collection;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractScanResultProvider
implements ScanResultProvider {
    protected EntityPlayer player;
    protected Vec3d center;
    protected float radius;

    @Override
    public int getEnergyCost(EntityPlayer player, ItemStack module) {
        return 50;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialize(EntityPlayer player, Collection<ItemStack> modules, Vec3d center, float radius, int scanTicks) {
        this.player = player;
        this.center = center;
        this.radius = radius;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isValid(ScanResult result) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.player = null;
        this.center = null;
        this.radius = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void renderQuad(float width, float height) {
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buffer = t.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        AbstractScanResultProvider.drawTexturedQuad(width, height, buffer);
        t.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void renderIconLabel(double posX, double posY, double posZ, float yaw, float pitch, Vec3d lookVec, Vec3d viewerEyes, float displayDistance, Vec3d resultPos, ResourceLocation icon, @Nullable String label) {
        Vec3d toResult = resultPos.func_178788_d(viewerEyes);
        float distance = (float)toResult.func_72433_c();
        float lookDirDot = (float)lookVec.func_72430_b(toResult.func_72432_b());
        float sqLookDirDot = lookDirDot * lookDirDot;
        float sq2LookDirDot = sqLookDirDot * sqLookDirDot;
        float focusScale = MathHelper.func_76131_a((float)(sq2LookDirDot * sq2LookDirDot + 0.005f), (float)0.5f, (float)1.0f);
        float scale = distance * focusScale * 0.005f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)resultPos.field_72450_a, (double)resultPos.field_72448_b, (double)resultPos.field_72449_c);
        GlStateManager.func_179137_b((double)(-posX), (double)(-posY), (double)(-posZ));
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
        if (lookDirDot > 0.999f && !Strings.isNullOrEmpty((String)label)) {
            String text = displayDistance > 0.0f ? I18n.func_135052_a((String)"gui.scannable.overlay.entity_details", (Object[])new Object[]{label, MathHelper.func_76123_f((float)displayDistance)}) : label;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int width = fontRenderer.func_78256_a(text) + 16;
            GlStateManager.func_179090_x();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(width / 2), (float)0.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
            AbstractScanResultProvider.renderQuad(width, fontRenderer.field_78288_b + 5);
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
            fontRenderer.func_175065_a(text, 12.0f, -4.0f, -1, true);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractScanResultProvider.renderQuad(16.0f, 16.0f);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawTexturedQuad(float width, float height, VertexBuffer buffer) {
        buffer.func_181662_b((double)(-width / 2.0f), (double)(height / 2.0f), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(width / 2.0f), (double)(height / 2.0f), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(width / 2.0f), (double)(-height / 2.0f), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(-width / 2.0f), (double)(-height / 2.0f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, VertexBuffer buffer) {
        AbstractScanResultProvider.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, buffer);
        AbstractScanResultProvider.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, buffer);
        AbstractScanResultProvider.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, buffer);
        AbstractScanResultProvider.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, buffer);
        AbstractScanResultProvider.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, buffer);
        AbstractScanResultProvider.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, buffer);
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a, VertexBuffer buffer) {
        AbstractScanResultProvider.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f, buffer);
        AbstractScanResultProvider.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f, buffer);
        AbstractScanResultProvider.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, r, g, b, a * 0.8f, buffer);
        AbstractScanResultProvider.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, r, g, b, a * 1.1f, buffer);
        AbstractScanResultProvider.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, r, g, b, a, buffer);
        AbstractScanResultProvider.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, r, g, b, a, buffer);
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, VertexBuffer buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, float r, float g, float b, float a, VertexBuffer buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, VertexBuffer buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, float r, float g, float b, float a, VertexBuffer buffer) {
        buffer.func_181662_b(x, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, VertexBuffer buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, float r, float g, float b, float a, VertexBuffer buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, VertexBuffer buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, float r, float g, float b, float a, VertexBuffer buffer) {
        buffer.func_181662_b(minX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, y, minZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, VertexBuffer buffer) {
        buffer.func_181662_b(minX, minY, z).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, float r, float g, float b, float a, VertexBuffer buffer) {
        buffer.func_181662_b(minX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, VertexBuffer buffer) {
        buffer.func_181662_b(minX, minY, z).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, float r, float g, float b, float a, VertexBuffer buffer) {
        buffer.func_181662_b(minX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, z).func_181666_a(r, g, b, a).func_181675_d();
    }
}

