/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.util;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class BlockInfo {
    private Block block;
    private int meta;

    public BlockInfo(IBlockState state) {
        this.block = state == null ? null : state.func_177230_c();
        this.meta = state == null ? -1 : state.func_177230_c().func_176201_c(state);
    }

    public BlockInfo(ItemStack stack) {
        this.block = stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemBlock) ? null : Block.func_149634_a((Item)stack.func_77973_b());
        this.meta = stack == null || stack.func_77973_b() == null ? null : Integer.valueOf(stack.func_77952_i());
    }

    public BlockInfo(String string) {
        String[] split = string.split(":");
        if (split.length == 1) {
            this.block = Block.func_149684_b((String)("minecraft:" + split[0]));
        } else if (split.length == 2) {
            try {
                this.meta = split[1].equals("*") ? -1 : Integer.parseInt(split[1]);
                this.block = Block.func_149684_b((String)("minecraft:" + split[0]));
            }
            catch (NumberFormatException e) {
                this.meta = -1;
                this.block = Block.func_149684_b((String)(split[0] + ":" + split[1]));
            }
        } else if (split.length == 3) {
            try {
                this.meta = split[2].equals("*") ? -1 : Integer.parseInt(split[2]);
                this.block = Block.func_149684_b((String)(split[0] + ":" + split[1]));
            }
            catch (NumberFormatException e) {
                this.meta = -1;
            }
        } else {
            this.meta = -1;
        }
    }

    public String toString() {
        return Block.field_149771_c.func_177774_c((Object)this.block) + (this.meta == -1 ? "" : ":" + this.meta);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
        tag.func_74768_a("meta", this.meta);
        return tag;
    }

    public static BlockInfo readFromNBT(NBTTagCompound tag) {
        Block item_ = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("block")));
        int meta_ = tag.func_74762_e("meta");
        return new BlockInfo(item_, meta_);
    }

    public IBlockState getBlockState() {
        return this.block == null ? null : this.block.func_176203_a(this.meta == -1 ? 0 : this.meta);
    }

    public int hashCode() {
        return this.block == null ? 37 : this.block.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof BlockInfo) {
            BlockInfo info = (BlockInfo)other;
            if (this.block == null || info.block == null) {
                return false;
            }
            if (this.meta == -1 || info.meta == -1) {
                return this.block.equals(info.block);
            }
            return this.meta == info.meta && this.block.equals(info.block);
        }
        return false;
    }

    public static boolean areEqual(BlockInfo block1, BlockInfo block2) {
        if (block1 == null && block2 == null) {
            return true;
        }
        if (block1 == null && block2 != null) {
            return false;
        }
        if (block1 != null && block2 == null) {
            return false;
        }
        return block1.equals(block2);
    }

    @ConstructorProperties(value={"block", "meta"})
    public BlockInfo(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }
}

