/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.tiles;

import exnihiloadscensio.barrel.BarrelFluidHandler;
import exnihiloadscensio.barrel.BarrelItemHandler;
import exnihiloadscensio.barrel.IBarrelMode;
import exnihiloadscensio.blocks.BlockBarrel;
import exnihiloadscensio.blocks.ENBlocks;
import exnihiloadscensio.config.Config;
import exnihiloadscensio.networking.MessageBarrelModeUpdate;
import exnihiloadscensio.networking.MessageCheckLight;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.BarrelModeRegistry;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileBarrel
extends TileEntity
implements ITickable {
    private IBarrelMode mode;
    private BarrelItemHandler itemHandler;
    private BarrelFluidHandler tank;
    private int tier;

    public TileBarrel() {
        this(ENBlocks.barrelWood);
    }

    public TileBarrel(BlockBarrel block) {
        this.tier = block.getTier();
        this.field_145854_h = block;
        this.itemHandler = new BarrelItemHandler(this);
        this.tank = new BarrelFluidHandler(this);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if (this.mode == null || this.mode.getName().equals("fluid")) {
            stack = player.func_184614_ca();
            boolean result = FluidUtil.interactWithFluidHandler((ItemStack)stack, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)), (EntityPlayer)player);
            if (result) {
                PacketHandler.sendNBTUpdate(this);
                if (this.func_145838_q().getLightValue(state, (IBlockAccess)world, pos) != world.func_175699_k(pos)) {
                    world.func_175664_x(pos);
                    PacketHandler.sendToAllAround(new MessageCheckLight(pos), this);
                }
                return true;
            }
            IFluidHandler tank = (IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            FluidStack bucketStack = FluidUtil.getFluidContained((ItemStack)stack);
            FluidStack tankStack = tank.drain(Integer.MAX_VALUE, false);
            if (bucketStack != null && tankStack != null && bucketStack.getFluid() == tankStack.getFluid() && tank.fill(FluidUtil.getFluidContained((ItemStack)stack), false) != 0) {
                tank.drain(1000, true);
                FluidUtil.interactWithFluidHandler((ItemStack)stack, (IFluidHandler)tank, (EntityPlayer)player);
                PacketHandler.sendNBTUpdate(this);
            }
        }
        if (this.mode == null) {
            if (player.func_184586_b(EnumHand.MAIN_HAND) != null) {
                stack = player.func_184586_b(EnumHand.MAIN_HAND);
                ArrayList<IBarrelMode> modes = BarrelModeRegistry.getModes(BarrelModeRegistry.TriggerType.ITEM);
                if (modes == null) {
                    return false;
                }
                for (IBarrelMode possibleMode : modes) {
                    if (!possibleMode.isTriggerItemStack(stack)) continue;
                    this.setMode(possibleMode.getName());
                    PacketHandler.sendToAllAround(new MessageBarrelModeUpdate(this.mode.getName(), this.field_174879_c), this);
                    this.mode.onBlockActivated(world, this, pos, state, player, side, hitX, hitY, hitZ);
                    this.func_70296_d();
                    this.field_145850_b.func_175656_a(pos, state);
                    if (this.func_145838_q().getLightValue(state, (IBlockAccess)world, pos) != world.func_175699_k(pos)) {
                        world.func_175664_x(pos);
                        PacketHandler.sendToAllAround(new MessageCheckLight(pos), this);
                    }
                    return true;
                }
            }
        } else {
            this.mode.onBlockActivated(world, this, pos, state, player, side, hitX, hitY, hitZ);
            if (this.func_145838_q().getLightValue(state, (IBlockAccess)world, pos) != world.func_175699_k(pos)) {
                world.func_175664_x(pos);
                PacketHandler.sendToAllAround(new MessageCheckLight(pos), this);
            }
            return true;
        }
        return true;
    }

    public void func_73660_a() {
        BlockPos plusY;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (Config.shouldBarrelsFillWithRain && (this.mode == null || this.mode.getName() == "fluid") && this.field_145850_b.func_175727_C(plusY = new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()))) {
            FluidStack stack = new FluidStack(FluidRegistry.WATER, 2);
            this.tank.fill(stack, true);
        }
        if (this.mode != null) {
            this.mode.update(this);
        }
        if (this.func_145838_q().getLightValue(this.field_145850_b.func_180495_p(this.field_174879_c), (IBlockAccess)this.field_145850_b, this.field_174879_c) != this.field_145850_b.func_175699_k(this.field_174879_c)) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
            PacketHandler.sendToAllAround(new MessageCheckLight(this.field_174879_c), this);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        if (this.mode != null) {
            NBTTagCompound barrelModeTag = new NBTTagCompound();
            this.mode.writeToNBT(barrelModeTag);
            barrelModeTag.func_74778_a("name", this.mode.getName());
            tag.func_74782_a("mode", (NBTBase)barrelModeTag);
        }
        NBTTagCompound handlerTag = this.itemHandler.serializeNBT();
        tag.func_74782_a("itemHandler", (NBTBase)handlerTag);
        tag.func_74768_a("barrelTier", this.tier);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.tank.readFromNBT(tag);
        if (tag.func_74764_b("mode")) {
            NBTTagCompound barrelModeTag = (NBTTagCompound)tag.func_74781_a("mode");
            this.setMode(barrelModeTag.func_74779_i("name"));
            if (this.mode != null) {
                this.mode.readFromNBT(barrelModeTag);
            }
        }
        if (tag.func_74764_b("itemHandler")) {
            this.itemHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("itemHandler"));
        }
        if (tag.func_74764_b("barrelTier")) {
            this.tier = tag.func_74762_e("barrelTier");
        }
        super.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return tag;
    }

    public void setMode(String modeName) {
        try {
            this.mode = modeName.equals("null") ? null : (IBarrelMode)BarrelModeRegistry.getModeByName(modeName).getClass().newInstance();
            this.func_70296_d();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMode(IBarrelMode mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public IBarrelMode getMode() {
        return this.mode;
    }

    public BarrelItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public BarrelFluidHandler getTank() {
        return this.tank;
    }

    public int getTier() {
        return this.tier;
    }
}

